{Projekt: FAHRPLAN

 Autor: Stefan Bormann 94,'95

 Inhalt: Werte, die im Optionenmen des Fahrplaneditors eingestellt werden
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT Optionen;

INTERFACE
USES AbstOpt, oWindows, xdiTools;


FUNCTION ExecuteEditorOptionen(aParent:PWindowsObject):boolean;
FUNCTION ExecuteAllgOptionen(aParent:PWindowsObject):boolean;
FUNCTION ExecuteDruckOptionen(aParent:PWindowsObject):boolean;



TYPE TZeitZoom=(Zoom_eins, Zoom_drei_halbe, Zoom_zwei, Zoom_drei);
     TZeitRaster=(Raster_eins, Raster_zwei, Raster_fuenf, Raster_zehn);


TYPE TZeitZoomOption=OBJECT(TEnumOption)
                       FUNCTION GetValue:TZeitZoom;
                     END;

TYPE TZeitRasterOption=OBJECT(TEnumOption)
                         FUNCTION GetValue:TZeitRaster;
                       END;

TYPE TButtonZeileOption=OBJECT(TEnumOption)
                          FUNCTION GetValue:TButtonZeilePosition;
                        END;


VAR ZeitZoom:TZeitZoomOption;
    ZeitRaster:TZeitRasterOption;
    AutoCheck:TBoolOption;
    FarbBalkenZeigen:TBoolOption;

    ButtonZeilePosition:TButtonZeileOption;
    StatusZeileDa:TBoolOption;

    DefaultDatenbank:TStringOption;
    DruckKommando:TStringOption;


IMPLEMENTATION
USES WinTypes, win_allg, Daten, mdi;

{********************************* Dialoge ***********************************}

FUNCTION ExecuteEditorOptionen(aParent:PWindowsObject):boolean;
VAR dlg:TOptionDialog;
    ZeitZoomControl:TEnumOptionControl;
    ZeitRasterControl:TEnumOptionControl;
    AutoCheckControl:TBoolOptionControl;
    FarbBalkenControl:TBoolOptionControl;
    ok:boolean;
BEGIN
  dlg.init(aparent, 'EditorOptionen', keineHilfe);

  ZeitZoomControl.init(@dlg, 102, @ZeitZoom);
  ZeitRasterControl.init(@dlg, 111, @ZeitRaster);
  AutoCheckControl.init(@dlg, 120, @AutoCheck);
  FarbBalkenControl.init(@dlg, 130, @FarbBalkenZeigen);

  ok:=(dlg.execute=id_ok);
  ExecuteEditorOptionen:=ok;
  if ok then FahrplanDaten.GetLinienArray^.EditorenNeueDaten;

  dlg.done;
END;

FUNCTION ExecuteAllgOptionen(aParent:PWindowsObject):boolean;
VAR dlg:TOptionDialog;
    ButtonZeileControl:TEnumOptionControl;
    StatusZeileControl:TBoolOptionControl;
    ok:boolean;
BEGIN
  dlg.init(aparent, 'AllgemeineOptionen', keineHilfe);

  ButtonZeileControl.init(@dlg, 102, @ButtonZeilePosition);
  StatusZeileControl.init(@dlg, 107, @StatusZeileDa);

  ok:=(dlg.execute=id_ok);
  ExecuteAllgOptionen:=ok;
  if ok then with PNewMDIWindow(Application^.MainWindow)^ do begin
    ButtonZeile^.SetPosition(ButtonZeilePosition.GetValue);
    StatusZeile^.SetSichtbar(StatusZeileDa.GetValue);
  end;

  dlg.done;
END;

FUNCTION ExecuteDruckOptionen(aParent:PWindowsObject):boolean;
VAR CommandLineControl:TStringOptionControl;
    dlg:TOptionDialog;
BEGIN
  dlg.init(aparent, 'DruckOptionen', keineHilfe);
  CommandLineControl.init(@dlg, 101, @DruckKommando);
  ExecuteDruckOptionen:=(dlg.execute=id_ok);
  dlg.done;
END;

{********************************* Daten *************************************}

FUNCTION TZeitZoomOption.GetValue:TZeitZoom;
BEGIN
  GetValue:=TZeitZoom(inherited GetValue);
END;

FUNCTION TZeitRasterOption.GetValue:TZeitRaster;
BEGIN
  GetValue:=TZeitRaster(inherited GetValue);
END;

FUNCTION TButtonZeileOption.GetValue:TButtonZeilePosition;
BEGIN
  GetValue:=TButtonZeilePosition(inherited GetValue);
END;

{-----------------------------------------------------------}

CONST ZeitZoomArray:Array [TZeitZoom] of pchar =('1', '1,5', '2', '3');
      ZeitRasterArray:Array [TZeitRaster] of pchar =('1', '2', '5', '10');
      ToolBarArray:Array [TButtonZeilePosition] of pchar =('oben', 'links', 'rechts', 'keine');

PROCEDURE Optionen_Init;
BEGIN
  AbstOpt.INIFileName:='FAHRPLAN.INI';

  ZeitZoom.init('Fahrplan', 'ZeitZoom', 0, ZeitZoomArray);
  ZeitRaster.init('Fahrplan', 'ZeitRaster', 0, ZeitRasterArray);
  AutoCheck.init('Fahrplan', 'AutoCheck', true);
  FarbBalkenZeigen.init('Fahrplan', 'FarbBalkenZeigen', true);

  ButtonZeilePosition.init('Fahrplan', 'ToolBar', 0, ToolBarArray);
  StatusZeileDa.init('Fahrplan', 'StatusZeile', true);

  DefaultDatenbank.init('Fahrplan', 'DefaultDatenbank', 'HO.BF', 200);
  DruckKommando.init('Fahrplan', 'DruckKommando', 'fpdru %s', 200);
END;


BEGIN
  Optionen_Init;
END.
