{Projekt: PLN-Datenstrukturen

 Autor: Stefan Bormann 95

 Inhalt: Typen, in denen Orte und Zeitpunkte einer Zugfahrt
         gespeichert werden koennen und Funktionen, die
         die gespeicherten Orte in lesbare Strings verwandeln
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT Ort_Zeit;

INTERFACE
USES NodeEdge, BfDef;


CONST minZeit=0;
      maxZeit=60*24;
      keineZeit=-18000; {soll heisse: ungueltige Zeit}
TYPE TZeit=integer;   {0h bis 24h ist nicht als "minZeit..maxZeit"
                       dekariert, weil Range-Checking sonst zu
                       oft mosern wuerde :-(
                       TZeit ist die Anzahl der Minuten seint 0h}
     ROrt=RECORD
            Knoten:PNode;  {nil=unbekannt}
            Gleis:hGleis;  {0=Strecke "hinter" Bf; Achtung: Seite}
          END;             {nicht definiert, weil die Richtung
                            beim Umdrehen der Linie vertauscht
                            werden kann}

FUNCTION Zeit2hmin(zeit:TZeit; immer_h:boolean):string;
{immer_h=false ist fuer die Darstellung von Zeitspannen
 sinnvoll (z.B. Aufenthaltszeiten).
 Beispiel: Zeit2hmin(65, egal)='1h 5min'
           Zeit2hmin(42, true)='0h 42min'
           Zeit2hmin(42, false)='42min'}

FUNCTION Ort2String(ort:ROrt):string;
FUNCTION RangeCheckZeit(zeit:TZeit):boolean;



IMPLEMENTATION
USES grund;

FUNCTION Zeit2hmin(zeit:TZeit; immer_h:boolean):string;
VAR s:string[16];
    flag:boolean;
BEGIN
  if RangeCheckZeit(zeit) then begin
    s:=zahlstr(zeit mod 60, 1)+'min';
    if immer_h or (zeit>=60) then begin
      if length(s)=4 then s:='0'+s;  {immer zweistellig}
      Zeit2hmin:=zahlstr(zeit div 60, 1)+'h '+s
    end else Zeit2hmin:=s;
  end else Zeit2hmin:='[keine Zeit]'
END;

FUNCTION Ort2String(ort:ROrt):string;
VAR s:string[maxBahnhofsName];
BEGIN
  if Ort.Knoten=nil then Ort2String:='nirgendwo' else begin
    s:=Ort.Knoten^.Bahnhof.Daten.name;
    if Ort.Gleis=0 then Ort2String:='Strecke hinter '+s
                   else Ort2String:=s+' auf Gleis '+Ort.Knoten^.Bahnhof.GetGleis(Ort.Gleis)^.Bezeichnung;
  end;
END;

FUNCTION RangeCheckZeit(zeit:TZeit):boolean;
BEGIN
  RangeCheckZeit:=(zeit>=minZeit) and (zeit<=maxZeit);
END;


END.
