UNIT Preview;

{$R preview.res}

INTERFACE
USES oPrinter, oWindows, WinTypes;

PROCEDURE ExecutePreview(parent:PWindowsObject; Printer:PPrinter; PrintOut:PPrintout);


IMPLEMENTATION
USES WinProcs, Win_Allg, grund;

TYPE TFenster=OBJECT(TWindow)
                Schliessen:boolean;
                Breite,Hoehe:integer;
                PrintOut:PPrintOut;
                CONSTRUCTOR init(aparent:PWindowsObject; br,hoe:word; PO:PPrintOut);
                PROCEDURE GetWindowClass(VAR class:TWndClass);       virtual;
                FUNCTION GetClassName:pchar;                         virtual;
                FUNCTION CanClose:boolean;                           virtual;
                PROCEDURE Paint(dc:hDC; VAR PaintInfo:TPaintStruct); virtual;

                PROCEDURE CMclose  (VAR Msg:TMessage);  virtual cm_first+20;
                PROCEDURE CMzoomin (VAR Msg:TMessage);  virtual cm_first+30;
                PROCEDURE CMzoomout(VAR Msg:TMessage);  virtual cm_first+40;
                PROCEDURE CMhilfe  (VAR Msg:TMessage);  virtual cm_first+50;
              END;


CONSTRUCTOR TFenster.init(aparent:PWindowsObject; br,hoe:word; PO:PPrintOut);
BEGIN
  Breite:=br;
  Hoehe:=hoe;
  Schliessen:=false;
  PrintOut:=PO;
  infofenster(zahlstr(br,1)+';  '+zahlstr(hoe,1));
  EnableWindow(aparent^.hWindow,false);
  inherited init(aparent, 'Druckvorschau');
  with attr do begin
    style:=ws_OverlappedWindow+ws_visible-ws_MinimizeBox;
    menu:=LoadMenu(hInstance, 'Preview');
  end;
END;

PROCEDURE TFenster.GetWindowClass(VAR class:TWndClass);
BEGIN
  inherited GetWindowClass(class);
  with class do begin
    hCursor:=LoadCursor(hInstance, 'Zoom_Lupe');
  end;
END;

FUNCTION TFenster.GetClassName:pchar;
BEGIN
  GetClassName:='FahrplanPreview';
END;

FUNCTION TFenster.CanClose:boolean;
BEGIN
  EnableWindow(parent^.hWindow,true);
  CanClose:=inherited CanClose;
  schliessen:=true;
END;

PROCEDURE TFenster.Paint(dc:hDC; VAR PaintInfo:TPaintStruct);
VAR altCursor:hCursor;
BEGIN
  altCursor:=SetCursor(LoadCursor(0, idc_wait));



  SetCursor(altCursor);
END;

PROCEDURE TFenster.CMclose(VAR Msg:TMessage);
BEGIN
  CloseWindow;
END;

PROCEDURE TFenster.CMzoomin(VAR Msg:TMessage);
BEGIN

END;

PROCEDURE TFenster.CMzoomout(VAR Msg:TMessage);
BEGIN

END;

PROCEDURE TFenster.CMhilfe(VAR Msg:TMessage);
BEGIN

END;


PROCEDURE ExecutePreview(parent:PWindowsObject; Printer:PPrinter; PrintOut:PPrintout);
VAR Fenster:^TFenster;
    Millimeter:TPoint;
    PrnDC:HDC;
BEGIN
  PrnDC := Printer^.GetDC;
  if PrnDC = 0 then Exit;
  Millimeter.X := GetDeviceCaps(PrnDC, HorzSize);
  Millimeter.Y := GetDeviceCaps(PrnDC, VertSize);
  DeleteDC(PrnDC);

  new(Fenster,init(parent, Millimeter.x, Millimeter.y, PrintOut));
  if Fenster=nil then runerror;
  if Application^.Makewindow(Fenster)=nil then runerror;
  Fenster^.Show(sw_normal);
  {Trick: enablewindow}
END;


END.
