{Projekt: PLN-Datenstrukturen

 Autor: Stefan Bormann 95

 Inhalt: Reglerfarben
}

UNIT RFarben;

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

INTERFACE
USES ZugArr, WinProcs, WinTypes;

FUNCTION SReglerFarbe2String(VAR ReglerFarben:SReglerFarbe):string;
FUNCTION ReglerFarbe2OrdnungsNummer(f:TReglerFarbe):word;

FUNCTION GetReglerFarbeColorRef(f:TReglerFarbe):TColorRef;
FUNCTION ReglerFarbeSelectSolid(dc:HDC; f:TReglerFarbe):THandle;
FUNCTION ReglerFarbeSelectThick(dc:HDC; f:TReglerFarbe):THandle;
FUNCTION ReglerFarbeSelectBrush(dc:HDC; f:TReglerFarbe):THandle;


IMPLEMENTATION
USES ProgExit;


FUNCTION SReglerFarbe2String(VAR ReglerFarben:SReglerFarbe):string;
VAR f:TReglerFarbe;
    erster:boolean;
    name:string[10];
    ergebnis:string[100];
BEGIN
  erster:=true;
  ergebnis:='';
  for f:=minReglerFarbe to maxReglerFarbe do begin
    if f in ReglerFarben then begin
      name:=GetReglerFarbeName(f);
      if erster then ergebnis:=name
                else ergebnis:=ergebnis+', '+name;
      erster:=false;
    end;
  end;
  SReglerFarbe2String:=Ergebnis;
END;

FUNCTION ReglerFarbe2OrdnungsNummer(f:TReglerFarbe):word;
BEGIN
  ReglerFarbe2OrdnungsNummer:=byte(f);
END;

CONST farben:array [TReglerFarbe] of record
                                     cr:TColorRef;
                                     pen_solid,pen_thick:HPen;
                                     brush:hBrush;
                                    end =
                          ((cr:0;         pen_solid:0; pen_thick:0; brush:0),
                           (cr:$00FF0000; pen_solid:0; pen_thick:0; brush:0),
                           (cr:$0000408F; pen_solid:0; pen_thick:0; brush:0),
                           (cr:$00606060; pen_solid:0; pen_thick:0; brush:0),
                           (cr:$0000FFFF; pen_solid:0; pen_thick:0; brush:0),
                           (cr:$00FF00FF; pen_solid:0; pen_thick:0; brush:0));

FUNCTION GetReglerFarbeColorRef(f:TReglerFarbe):TColorRef;
BEGIN
  GetReglerFarbeColorRef:=Farben[f].cr;
END;

FUNCTION ReglerFarbeSelectSolid(dc:HDC; f:TReglerFarbe):THandle;
BEGIN
  ReglerFarbeSelectSolid:=selectobject(dc,farben[f].pen_solid);
END;

FUNCTION ReglerFarbeSelectThick(dc:HDC; f:TReglerFarbe):THandle;
BEGIN
  ReglerFarbeSelectThick:=selectobject(dc,farben[f].pen_thick);
END;

FUNCTION ReglerFarbeSelectBrush(dc:HDC; f:TReglerFarbe):THandle;
BEGIN
  ReglerFarbeSelectBrush:=selectobject(dc,farben[f].brush);
END;

{********************************* Farben *************************************}

PROCEDURE KillPens; FAR;
VAR f:TReglerFarbe;
BEGIN
  for f:=minReglerFarbe to maxReglerFarbe do with farben[f] do begin
    deleteobject(pen_solid);
    deleteobject(pen_thick);
    deleteobject(brush);
  end;
END;

VAR f:TReglerFarbe;
BEGIN
  RegisterExitproc(KillPens);
  for f:=minReglerFarbe to maxReglerFarbe do with farben[f] do begin
    pen_solid:=createpen(ps_solid,1,cr);
    pen_thick:=createpen(ps_solid,2,cr);
    brush:=CreateSolidBrush(cr);
  end;
END.
