{Allgemeinverwendbares Modul

 Autor: Stefan Bormann 94

 Inhalt: Scrollbar mit veriabler Lnge des mittleren Buttons
}

{$A+,B-,D+,F-,G+,I+,K+,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT ScrollBar;

INTERFACE
USES oWindows, oDialogs, WinTypes, WinProcs;

CONST wm_UserNotifyButtonDown=wm_user+0;
      wm_UserNotifyButtonMove=wm_User+1;

TYPE PSuperScrollBarButton=^TSuperScrollBarButton;
     TSuperScrollBarButton=OBJECT(TButton)
                             FUNCTION GetClassName:pchar;  virtual;
                           END;

TYPE TSuperScrollBar=OBJECT(TWindow)
                       Gesammt,      {Anzahl der Schritte durch das Dokument}
                       Seite,        {Anzahl der Schritte, die im Fenster sichtbar sind}
                       Position:word;{Anzahl der Schritte, die der obere Fensterrand
                                      vom oberen Rand des Dokuments entfernt ist}
                       CONSTRUCTOR init(aparent:PWindowsObject; x,y,w,h:integer; wm:word);
                       FUNCTION GetClassName:pchar;           virtual;
                       PROCEDURE GetWindowClass(VAR aWndClass:TWndClass); virtual;
                       FUNCTION SetPosition(neu:word):boolean;
                       PROCEDURE SetSeite(neu:word);
                       PROCEDURE IDplus (VAR Msg:TMessage); virtual id_first+252;
                       PROCEDURE IDminus(VAR Msg:TMessage); virtual id_first+253;
                       PROCEDURE WMlButtonDown(VAR Msg:TMessage); virtual wm_first+wm_lButtonDown;
                       PROCEDURE WMlButtonUp  (VAR Msg:TMessage); virtual wm_first+wm_lButtonUp;
                       PROCEDURE WMMouseMove  (VAR Msg:TMessage); virtual wm_first+wm_MouseMove;
                       PROCEDURE PageDown;
                       PROCEDURE PageUp;
                       FUNCTION Point2Pixel(Punkt:TPoint):integer; virtual;
                     PRIVATE
                       PlusButton, MinusButton:PSuperScrollBarButton;
                       MitteSichtbar:boolean;
                       Message:word;
                       LaufLeisteStart,LaufLeisteEnde,LaufLeisteBreite:integer;
                       DragAbstand:integer;
                       Gedrueckt:boolean;
                       FUNCTION Partitionierung(VAR Anfang, Ende:integer):boolean;
                       FUNCTION Einheit2Pixel(Einheit:word):integer;
                       FUNCTION Pixel2Einheit(Pixel:integer):word;
                       PROCEDURE NeuZeichnen;
                     END;

TYPE PVerticalScrollBar=^TVerticalScrollBar;
     TVerticalScrollBar=OBJECT(TSuperScrollBar)
                          PROCEDURE WMSize(VAR Msg:TMessage); virtual wm_first+wm_Size;
                          PROCEDURE Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
                          FUNCTION Point2Pixel(Punkt:TPoint):integer; virtual;
                        END;

TYPE PHorizontalScrollBar=^THorizontalScrollBar;
     THorizontalScrollBar=OBJECT(TSuperScrollBar)
                            PROCEDURE WMSize(VAR Msg:TMessage); virtual wm_first+wm_Size;
                            PROCEDURE Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;
                            FUNCTION Point2Pixel(Punkt:TPoint):integer; virtual;
                          END;


IMPLEMENTATION
USES objects;


FUNCTION TSuperScrollBarButton.GetClassName:pchar;
BEGIN
  GetClassName:='Button';
END;


CONSTRUCTOR TSuperScrollBar.init(aparent:PWindowsObject; x,y,w,h:integer; wm:word);
BEGIN
  inherited init(aparent, 'SuperScrollbar');
  attr.x:=x;
  attr.y:=y;
  attr.w:=w;
  attr.h:=h;
  attr.style:=attr.style or ws_border or ws_child or ws_visible;
  Gesammt:=1;
  Seite:=1;
  Position:=0;
  Message:=wm;
  new(PlusButton,  init(@self, 252, '+', 0,0,0,0, false));
  new(MinusButton, init(@self, 253, '-', 0,0,0,0, false));
  MitteSichtbar:=true;
  Gedrueckt:=false;
END;

FUNCTION TSuperScrollBar.GetClassName:pchar;
BEGIN
  GetClassName:='SuperScrollBar';
END;

PROCEDURE TSuperScrollBar.GetWindowClass(VAR aWndClass:TWndClass);
BEGIN
  inherited GetWindowClass(aWndClass);
  with aWndClass do begin
    hBrBackGround:=GetStockObject(LtGray_Brush);
    style:=style or cs_Vredraw or cs_Hredraw;
  end;
END;

PROCEDURE TSuperScrollBar.IDplus(VAR Msg:TMessage);
BEGIN
  if Position<gesammt-seite then SetPosition(Position+1);
END;

PROCEDURE TSuperScrollBar.IDminus(VAR Msg:TMessage);
BEGIN
  if Position>0 then SetPosition(Position-1);
END;

PROCEDURE TSuperScrollBar.PageDown;
BEGIN
  if not MitteSichtbar then exit;
  if Position>Seite
    then SetPosition(Position-Seite)
    else SetPosition(0);
END;

PROCEDURE TSuperScrollBar.PageUp;
BEGIN
  if not MitteSichtbar then exit;
  if Position+Seite+Seite<Gesammt
    then SetPosition(Position+Seite)
    else SetPosition(Gesammt-Seite);
END;

FUNCTION TSuperScrollBar.Einheit2Pixel(Einheit:word):integer;
BEGIN
  Einheit2Pixel:=LaufLeisteStart + (longint(Einheit) * longint(LaufLeisteEnde+1-LaufLeisteStart) div Gesammt);
END;

FUNCTION TSuperScrollBar.Pixel2Einheit(Pixel:integer):word;
BEGIN
  Pixel2Einheit:=round(longint(Pixel-LaufLeisteStart) * longint(Gesammt) / (LaufLeisteEnde+1-LaufLeisteStart));
END;

FUNCTION TSuperScrollBar.Partitionierung(VAR Anfang, Ende:integer):boolean;
VAR ok:boolean;
    pixel:longint;
BEGIN
  ok:=(Gesammt>0) and (Seite>0) and (Seite<Gesammt);
  Partitionierung:=ok;
  if ok then begin
    Anfang:=Einheit2Pixel(Position);
    Ende  :=Einheit2Pixel(Position+Seite)-1;
    if LaufLeisteEnde<Ende then Ende:=LaufLeisteEnde;
  end;
END;

FUNCTION TSuperScrollBar.SetPosition(neu:word):boolean;
VAR ok:boolean;
BEGIN
  ok:=neu<=gesammt-seite;
  SetPosition:=ok;
  if (not ok) or (Neu=Position) then exit;
  Position:=neu;
  NeuZeichnen;
  SendMessage(parent^.hWindow, Message, Position, 0);
END;

PROCEDURE TSuperScrollBar.SetSeite(neu:word);
BEGIN
  Seite:=neu;
  NeuZeichnen;
END;

PROCEDURE TSuperScrollBar.WMlButtonDown(VAR msg:TMessage);
VAR a,e:integer;
    Pixel:integer;
BEGIN
  Pixel:=Point2Pixel(MakePoint(msg.lParam));
  if MitteSichtbar and (Pixel>=LaufLeisteStart) and (Pixel<=LaufLeisteEnde) then begin
    a:=Einheit2Pixel(Position);
    e:=Einheit2Pixel(Position+Seite)-1;
    if (Pixel<a) then PageDown
    else if (Pixel>e) then PageUp
    else begin
      DragAbstand:=Pixel-a;
      SetCapture(hWindow);
      Gedrueckt:=true;
    end;
  end;
END;

PROCEDURE TSuperScrollBar.WMlButtonUp(VAR Msg:TMessage);
BEGIN
  ReleaseCapture;
  Gedrueckt:=false;
END;

PROCEDURE TSuperScrollBar.WMMouseMove(VAR Msg:TMessage);
VAR Pixel:integer;
BEGIN
  if gedrueckt then begin
{    ScreenToClient(hWindow, MakePoint(msg.lParam));}
    Pixel:=Point2Pixel(MakePoint(msg.lParam))-DragAbstand;
    if Pixel<LaufLeisteStart then SetPosition(0)
    else if Pixel>LaufLeisteEnde then SetPosition(gesammt-seite)
    else SetPosition(Pixel2Einheit(Pixel));
  end;
END;

PROCEDURE TSuperScrollBar.NeuZeichnen;
BEGIN
  InvalidateRect(hWindow, nil, true);
END;

FUNCTION TSuperScrollBar.Point2Pixel(Punkt:TPoint):integer;
BEGIN  abstract;  END;

{----------------------------------------------------------------------------}

PROCEDURE TVerticalScrollBar.WMSize(VAR Msg:TMessage);
VAR CR:TRect;
BEGIN
  GetClientRect(hWindow, CR);
  if cr.bottom<cr.right*2 then exit;

  LaufLeisteBreite:=cr.right;
  LaufLeisteStart:=LaufLeisteBreite+1;
  LaufLeisteEnde:=cr.bottom-LaufLeisteBreite-1;

  MoveWindow(MinusButton^.hWindow, -1, -1, LaufLeisteBreite+2, LaufLeisteStart+1, true);
  MoveWindow(PlusButton^.hWindow,  -1, LaufLeisteEnde+1, LaufLeisteBreite+2, cr.bottom-LaufLeisteEnde+1, true);
END;

PROCEDURE TVerticalScrollBar.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
VAR a,e:integer;
    altBrush, Brush:hBrush;
BEGIN
  Brush:=GetStockObject(gray_brush);
  altBrush:=selectobject(paintdc, brush);
  MitteSichtbar:=Partitionierung(a, e);
  if MitteSichtbar then Rectangle(paintdc, 1, a, LaufLeisteBreite-1, e+1);
  selectobject(paintdc, altbrush);
END;

FUNCTION TVerticalScrollBar.Point2Pixel(Punkt:TPoint):integer;
BEGIN
  Point2Pixel:=Punkt.y;
END;

{--------------------------------------------------------------------}

PROCEDURE THorizontalScrollBar.WMSize(VAR Msg:TMessage);
VAR CR:TRect;
BEGIN
  GetClientRect(hWindow, CR);
  if cr.right<cr.bottom*2 then exit;

  LaufLeisteBreite:=cr.bottom;
  LaufLeisteStart:=LaufLeisteBreite+1;
  LaufLeisteEnde:=cr.right-LaufLeisteBreite-1;

  MoveWindow(MinusButton^.hWindow, -1, -1, LaufLeisteStart+1, LaufLeisteBreite+2, true);
  MoveWindow(PlusButton^.hWindow,  LaufLeisteEnde+1, -1, laufLeisteBreite+1, LaufLeisteBreite+2, true);
END;

PROCEDURE THorizontalScrollBar.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
VAR a,e:integer;
    altBrush, Brush:hBrush;
BEGIN
  Brush:=GetStockObject(gray_brush);
  altBrush:=selectobject(paintdc, brush);
  MitteSichtbar:=Partitionierung(a, e);
  if MitteSichtbar then Rectangle(paintdc, a, 1, e+1, LaufLeisteBreite-1);
  selectobject(paintdc, altbrush);
END;

FUNCTION THorizontalScrollBar.Point2Pixel(Punkt:TPoint):integer;
BEGIN
  Point2Pixel:=Punkt.x;
END;

END.
