UNIT Spalten;

{$A+,B-,G+,I+,V-,X+,N+,W-}
{$D+,L+,R+,S+}

INTERFACE
USES heap, nodeedge, Ort_Zeit, Strecke, BfDef;

TYPE iSpalten=word;   {Index im SpaltenArray}

TYPE PSpalte=^RSpalte;
     RSpalte=RECORD
               StreckenAbschnitt:iStrecke;  {Index im StreckenArray}
               Knoten:PNode;
               Gleis:hGleis;      {Index im GleisArray von BfManag; 0=Strecke rechts vom Bahnhof}
               X:word;            {Position der Gleislinie im Fenster}
               Name:string[3];    {Nutzbar nur Lnge 2, weil nullterminiert}
             END;

TYPE TSpaltenArray=OBJECT(RecordArrayObj)
                   {Array ueber die senkrechten Linien in einem Editorfenster (bzw. Bildfahrplan auf dem Papier)}
                     CONSTRUCTOR init;
                     FUNCTION GetKnoten(i:iSpalten):PNode;
                     FUNCTION GetGleis(i:iSpalten):hGleis;
                     FUNCTION GetName(i:iSpalten):string;
                     FUNCTION GetX(i:iSpalten):integer;
                     FUNCTION Ort2Spalte(Ort:ROrt):iSpalten;
                     FUNCTION GetGesammtBreite:word;
                     PROCEDURE SetOffset(neu:integer);
                   PRIVATE
                     GesammtBreite:word;
                     Offset:integer;
                     PROCEDURE Dazu(Spalte:iSpalten; StrBf:iStrecke; Knoten:PNode; Gleis:hGleis; X:word; name:string);
                     FUNCTION GetRec(i:iSpalten):PSpalte;
                   END;

FUNCTION Strecke2Spalten(const Strecke:TStreckenArray; VAR Spalten:TSpaltenArray; links,rechts,abstGleis:integer):boolean;

CONST MinAbstBahnhof=50;


IMPLEMENTATION
USES grund;


{********************************** SpaltenArray ***********************************}

CONSTRUCTOR TSpaltenArray.init;
BEGIN
  inherited init(sizeof(RSpalte));
END;

FUNCTION TSpaltenArray.Ort2Spalte(Ort:ROrt):iSpalten;
VAR self_anzahl:word;
    ds_cp:word;

    w:word;
BEGIN

  for w:=1 to anzahl do with GetRec(w)^ do begin
    if (Knoten=Ort.Knoten) and (Gleis=Ort.Gleis) then begin
      Ort2Spalte:=w;
      exit;
    end;
  end;
  Ort2Spalte:=0;
  exit;

  ASM
    mov ds_cp,ds

    les di,self
    lds si,TSpaltenArray(es:[di]).p            {Zeiger auf Array in DS:SI}
    mov cx,TSpaltenArray(es:[di]).anzahl       {Zaehler in CX}
    mov self_anzahl,cx                {fuer Rueckgabewert merken}
    mov dx,ort.Gleis                  {ort.Gleis in DX}
    les ax,ort.Knoten
    mov bx,es                         {ort.Knoten in BX:AX}

  @@Schleife:
    les di,ds:[si]                    {Zeiger auf aktuelle Spalte nach ES:DI}
    cmp SuperPointer(RSpalte(es:[di]).Knoten).o, ax  {Vergleich Offset des Knotenptrs}
    jne @@ungleich
    cmp RSpalte(es:[di]).Gleis, dx                   {Vergleich des Gleishandles}
    jne @@ungleich
    cmp SuperPointer(RSpalte(es:[di]).Knoten).s, bx  {Vergleich Segment des Knotenptrs}
    jne @@ungleich
    mov ax,self_anzahl
    sub ax,cx      {countdown abziehen}
    inc ax
    jmp @@gefunden

  @@ungleich:
    add bx,4      {sizeof(pointer) hochzaehlern = zum nachsten Arrayindex schalten}
    LOOP @@Schleife
    mov ax,0      {Rueckgabewert=0, wenn nicht gefunden}

  @@gefunden:

    mov ds,ds_cp
  END;
END;

PROCEDURE TSpaltenArray.Dazu(Spalte:iSpalten; StrBf:iStrecke; Knoten:PNode; Gleis:hGleis; X:word; name:string);
VAR sp:PSpalte;
    w:word;
BEGIN
  new(sp);
  sp^.StreckenAbschnitt:=StrBf;
  sp^.Knoten:=Knoten;
  sp^.Gleis:=Gleis;
  sp^.x:=X;
  w:=length(Name);
  if w>2 then w:=1;
  sp^.Name:=copy(Name,1,w);
  sp^.Name[w+1]:=#0;
  p^[Spalte]:=sp;
END;

FUNCTION TSpaltenArray.GetRec(i:iSpalten):PSpalte;
BEGIN
  if (i<1) or (i>anzahl)
  then runerror;
  GetRec:=p^[i];
END;

FUNCTION TSpaltenArray.GetKnoten(i:iSpalten):PNode;
BEGIN
  GetKnoten:=GetRec(i)^.Knoten;
END;

FUNCTION TSpaltenArray.GetGleis(i:iSpalten):hGleis;
BEGIN
  GetGleis:=GetRec(i)^.Gleis;
END;

FUNCTION TSpaltenArray.GetName(i:iSpalten):string;
BEGIN
  GetName:=GetRec(i)^.Name;
END;

FUNCTION TSpaltenArray.GetX(i:iSpalten):integer;
BEGIN
  GetX:=GetRec(i)^.X-Offset;
END;

FUNCTION TSpaltenArray.GetGesammtBreite:word;
BEGIN
  GetGesammtBreite:=GesammtBreite;
END;

PROCEDURE TSpaltenArray.SetOffset(neu:integer);
BEGIN
  Offset:=neu;
END;


{********************************* Rberschaufelfunktion ***************************}

FUNCTION Strecke2Spalten(const Strecke:TStreckenArray; VAR Spalten:TSpaltenArray; Links,Rechts,abstGleis:integer):boolean;
VAR bfs:iStrecke;        {Index im StreckenArray}
    gl:hGleis;           {Index im GleisArray von BfManag}
    glp:PGleisDaten;
    anzgl:word;          {Gesamtzahl aller Zugfahrtengleise aller Bahnhfe der Strecke}
    aufzuteilen:word;    {Koordinaten zwischen den Bahnhfen}
    StreckenLaenge:word; {Gesammtlnge der Strecke zwischen erstem und letztem Bahnhof}
    PixelProMeter:single;
    PixelPos:word;
    w:word;              {Feuerwehrvariable}
    Knoten:PNode;

    minBreite,festBreite:word;
    index:iSpalten;       {Index im Spaltenarray}
    FensterBreite:integer;
 BEGIN
  FensterBreite:=Rechts-Links;
  if FensterBreite<1 then runerror;
{altes Array freigeben}
  Spalten.Free;
{Wenn nicht gengend Daten zum Anzeigen da sind => gleich raus}
  if Strecke.GetAnzahl<2 then exit;
{Anzahl der Gleise herausfinden (=Gre des SpaltenArrays)
 festBreite und minBreite Ermitteln}
  anzgl:=0;
  festBreite:=0;
  StreckenLaenge:=0;
  for bfs:=1 to Strecke.GetAnzahl do begin
    if bfs<>Strecke.GetAnzahl then inc(StreckenLaenge,Strecke.GetStr(bfs));
    w:=Strecke.GetNode(bfs)^.Bahnhof.AnzahlGleise;
    if w=0 then runerror;
    inc(anzgl,w);
    inc(festBreite,abstGleis*(w-1));
  end;
  minBreite:=festBreite+Strecke.GetAnzahl*MinAbstBahnhof;
  inc(festBreite,MinAbstBahnhof);  {rechts, links Abstand vom Rand}
  if minBreite>=FensterBreite then begin
    Strecke2Spalten:=false;
    Spalten.GesammtBreite:=minBreite;
  end else begin
    Strecke2Spalten:=true;
    Spalten.GesammtBreite:=FensterBreite;
  end;
  inc(anzgl,Strecke.GetAnzahl-1); {Steckenabschnitte mitzhlen}
  Spalten.Erweiterung(anzgl);
  Aufzuteilen:=Spalten.GesammtBreite-festBreite;
  PixelProMeter:=Aufzuteilen/StreckenLaenge;
{Spaltenarray mit Daten fllen}
  index:=0;
  PixelPos:=MinAbstBahnhof div 2;  {links Abstand vom Rand}
  for bfs:=1 to Strecke.GetAnzahl do begin
    Knoten:=Strecke.GetNode(bfs);
    for gl:=1 to Knoten^.Bahnhof.AnzahlGleise do begin
      glp:=Knoten^.Bahnhof.GetGleis(gl);
      inc(index);
      Spalten.dazu(index, bfs, Knoten, gl, PixelPos+Links, glp^.Bezeichnung);
      inc(PixelPos,abstGleis);
    end;
    dec(PixelPos,abstGleis); {letztes inc wieder rueckgaengig}
    if bfs<>Strecke.GetAnzahl then begin
      w:=round(PixelProMeter*Strecke.GetStr(bfs));
      inc(index);
      Spalten.dazu(index, bfs, Knoten, 0, PixelPos+(w div 2)+Links, '');
      inc(PixelPos,w);
    end;
  end;
  if index<>Spalten.Anzahl then runerror;
END;


END.
