{Projekt: PLN-Datenstrukturen

 Autor: Stefan Bormann 95

 Inhalt: TStreckenArray ist ein Array ueber die Knoten, an
         denen eine bestimmte Linie vorbeifuehrt.

 Referenzen: In jedem Linien-Objekt gibt es genau ein
             Feld vom Typ TStreckenArray.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT Strecke;

INTERFACE
USES NodeEdge, heap;

TYPE iStrecke=word;   {Index im StreckenArray}

TYPE PStreckenArray=^TStreckenArray;
     TStreckenArray=OBJECT
                      CONSTRUCTOR init;
                      DESTRUCTOR done;  virtual;
                      FUNCTION GetNode(i:iStrecke):PNode;
                      FUNCTION GetStr(i:iStrecke):word;
                      PROCEDURE Aufbauen(anfang,ende:Pnode; Farbe:TGraphenFarbe);
                      FUNCTION GetAnzahl:word;
                    PRIVATE
                      Arr:TDynArray;
                    END;


IMPLEMENTATION

{******************************** StreckenArray ***********************************}

CONSTRUCTOR TStreckenArray.init;
BEGIN
  Arr.init;
END;

DESTRUCTOR TStreckenArray.done;
BEGIN
  Arr.done;
END;

FUNCTION TStreckenArray.GetNode(i:iStrecke):PNode;
BEGIN
  if (i=0) or (i>Arr.anzahl) then runerror;
  GetNode:=Arr.p^[i];
END;

FUNCTION TStreckenArray.GetStr(i:iStrecke):word;
BEGIN
  if (i=0) or (i>=Arr.anzahl)
  then runerror;
  GetStr:=1;
END;

PROCEDURE TStreckenArray.Aufbauen(anfang,ende:Pnode; Farbe:TGraphenFarbe);
VAR hinten,           {da kommen wir her}
    kante,            {da gehn wir nun wirklich hin}
    vorn:Pedge;       {wolln wir da hin???}
    gefunden,         {Anzahl der gefundenen Kanten ohne zurck-Kante}
    i:word;           {Schleifenzhler, um Nachbarkanten zu testen}
    Knoten:Pnode;     {neu zu betretender Knoten}
BEGIN
  Arr.Free;
  if anfang=ende then runerror;
  hinten:=nil;   {beim Einstieg gibt es noch keine Vorluferkante}
  repeat
{aktuellen Knoten in das Array eintragen:}
    Arr.append(Anfang);
    gefunden:=0;
{Schleife ber alle Kanten, die vom aktuellen Knoten abgehen}
    for i:=1 to anfang^.anzahl do begin
      vorn:=anfang^.GetEdge(i);
      if vorn^.Faerbung[Farbe] and    {Kante hat Farbe der Linie}
         (vorn<>hinten) then begin  {kein Weg zurck}
        Knoten:=anfang^.GetNode(i); {zum nchsten Knoten schalten}
        inc(gefunden);
        Kante:=vorn;
      end;
    end;
    anfang:=Knoten;
    if (gefunden=0) then if anfang=ende then exit
                                        else runerror
    else if gefunden<>1 then runerror;  {dann mu es genau eine richtige Kante geben}
    hinten:=kante;
  until false;
END;

FUNCTION TStreckenArray.GetAnzahl:word;
BEGIN
  GetAnzahl:=Arr.Anzahl;
END;


END.
