{Projekt: BAHNHOF.DLL

 Autor: Stefan Bormann 94

 Inhalt: Interface der neuen BAHNHOF.DLL, die BFMANAG.DLL abloest.
}


UNIT uBahnhof;

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

INTERFACE
USES BfDef, WinTypes;

FUNCTION Bf_OpenDirect(parent:hWnd; Dateiname:pchar):hDatenbank;
FUNCTION Bf_OpenDialog(parent:hWnd):hDatenbank;
FUNCTION Bf_CreateDialog(parent:hWnd):hDatenbank;
FUNCTION Bf_Close(Datenbank:hDatenbank):boolean;
FUNCTION Bf_GetFileName(Datenbank:hDatenbank; Puffer:pchar; MaxChars:word):word;
FUNCTION Bf_GetStatus(Datenbank:hDatenbank):TDatenbankStatus;

FUNCTION Bf_BahnhofsAuswahlDialog(parent:hWnd; Datenbank:hDatenbank; Titel:pchar):hBahnhof;
PROCEDURE Bf_ExecuteStatusDialog(parent:hWnd);

FUNCTION Bf_Aufzaehlung(Datenbank:hDatenbank; AufzaehlProc:TAufzaehlProc):TBfError;
FUNCTION Bf_BahnhofDazu(Datenbank:hDatenbank):hBahnhof;
FUNCTION Bf_BahnhofLoeschen(Datenbank:hDatenbank; Bahnhof:hBahnhof):TBfError;

FUNCTION Bf_GetData(Datenbank:hDatenbank; Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError;
FUNCTION Bf_SetData(Datenbank:hDatenbank; Bahnhof:hBahnhof; DatenPuffer:PBahnhofsDaten):TBfError;

FUNCTION Bf_GetInfo(Datenbank:hDatenbank; Bahnhof:hBahnhof; InfoPuffer:pchar; MaxChars:word):word;
FUNCTION Bf_SetInfo(Datenbank:hDatenbank; Bahnhof:hBahnhof; InfoPuffer:pchar):TBfError;

FUNCTION Bf_Info2Window(Datenbank:hDatenbank; Bahnhof:hBahnhof; Window:hWnd):TBfError;
FUNCTION Bf_Window2Info(Datenbank:hDatenbank; Bahnhof:hBahnhof; Window:hWnd):TBfError;

FUNCTION Bf_GetGleisAnzahl(Datenbank:hDatenbank; Bahnhof:hBahnhof):word;
FUNCTION Bf_GetGleis(Datenbank:hDatenbank; Bahnhof:hBahnhof; Gleis:hGleis; GleisPuffer:PGleisDaten):TBfError;
FUNCTION Bf_GleisDazu(Datenbank:hDatenbank; Bahnhof:hBahnhof; GleisPuffer:PGleisDaten):hGleis;
FUNCTION Bf_GleiseLoeschen(Datenbank:hDatenbank; Bahnhof:hBahnhof):TBfError;


IMPLEMENTATION
USES Win_Allg, Strings, WinProcs;

CONST DLLname='BAHNHOF';

FUNCTION Bf_OpenDirect;            external DLLname index 10;
FUNCTION Bf_OpenDialog;            external DLLname index 11;
FUNCTION Bf_CreateDialog;          external DLLname index 12;
FUNCTION Bf_Close;                 external DLLname index 13;
FUNCTION Bf_GetFileName;           external DLLname index 14;
FUNCTION Bf_GetStatus;             external DLLname index 15;

FUNCTION Bf_BahnhofsAuswahlDialog; external DLLname index 20;
PROCEDURE Bf_ExecuteStatusDialog;  external DLLname index 21;

FUNCTION Bf_Aufzaehlung;           external DLLname index 30;
FUNCTION Bf_BahnhofDazu;           external DLLname index 31;
FUNCTION Bf_BahnhofLoeschen;       external DLLname index 32;

FUNCTION Bf_GetData;               external DLLname index 40;
FUNCTION Bf_SetData;               external DLLname index 41;
FUNCTION Bf_GetInfo;               external DLLname index 42;
FUNCTION Bf_SetInfo;               external DLLname index 43;
FUNCTION Bf_Info2Window;           external DLLname index 44;
FUNCTION Bf_Window2Info;           external DLLname index 45;

FUNCTION Bf_GetGleisAnzahl;        external DLLname index 50;
FUNCTION Bf_GetGleis;              external DLLname index 51;
FUNCTION Bf_GleisDazu;             external DLLname index 52;
FUNCTION Bf_GleiseLoeschen;        external DLLname index 53;

END.
