{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: TUmrechner kapselt die Umrechnung zwischen y-Pixeln und
         korespondierenden Zeiten und wird vom Editorfenster,
         sowie dem EditorSheet und FarbBalken benutzt.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT Zeit_Y;

INTERFACE
USES Ort_Zeit;

TYPE PUmrechner=^TUmrechner;
     TUmrechner=OBJECT
                  CONSTRUCTOR init;
                  PROCEDURE SetFensterObenZeit(neu_foz:TZeit);
                  FUNCTION Zeit2Y(Zeit:TZeit):integer;
                  FUNCTION Y2Zeit(y:integer):TZeit;
                  PROCEDURE SetZoom;
                  FUNCTION GetFensterObenZeit:TZeit;
                PRIVATE
                  FensterObenZeit:TZeit;      {Zeit bei y=0}
                  d_Pixel, d_Zeit:integer;
                END;


IMPLEMENTATION
USES Optionen;


CONSTRUCTOR TUmrechner.init;
BEGIN
  FensterObenZeit:=0;
  d_Pixel:=0;
  d_Zeit:=0;
END;

PROCEDURE TUmrechner.SetFensterObenZeit(neu_foz:TZeit);
BEGIN
  FensterObenZeit:=neu_foz;
END;

FUNCTION TUmrechner.Zeit2Y(zeit:TZeit):integer;
BEGIN
  Zeit2Y:=(Zeit-FensterObenZeit) * d_Pixel div d_Zeit;
END;

FUNCTION TUmrechner.Y2Zeit(y:integer):TZeit;
BEGIN
  Y2Zeit:=(Y * d_Zeit div d_Pixel) +FensterObenZeit
END;

PROCEDURE TUmrechner.SetZoom;
BEGIN
  case TZeitZoom(ZeitZoom.GetValue) of
    Zoom_eins      :begin  d_Pixel:=1; d_Zeit:=1;  end;
    Zoom_drei_halbe:begin  d_Pixel:=3; d_Zeit:=2;  end;
    Zoom_zwei      :begin  d_Pixel:=2; d_Zeit:=1;  end;
    Zoom_drei      :begin  d_Pixel:=3; d_Zeit:=1;  end;
    else runerror;
  end;
END;

FUNCTION TUmrechner.GetFensterObenZeit:TZeit;
BEGIN
  GetFensterObenZeit:=FensterObenZeit;
END;


END.
