{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: "TZugArray" ist ein dynamisches Array ueber Objekte vom
         Typ "TZug"
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT ZugArr;

INTERFACE
USES Heap, Ort_Zeit, NodeEdge;


{************************* Reglerfarbe *************************}

TYPE TReglerFarbe=(keine,blau,braun,grau,gelb,violett);
     SReglerFarbe=set of TReglerFarbe;
CONST minReglerFarbe=keine;
      maxReglerFarbe=violett;
      MaxReglerFarbeName=9;

FUNCTION GetReglerFarbeName(f:TReglerFarbe):string;

{************************* Zugdaten ****************************}

TYPE PZugDatum=^RZugDatum;
     RZugDatum=RECORD
                 Ort:ROrt;
                 anZeit,abZeit:TZeit;
               END;

CONST MaxZugName=50;

TYPE PAbstractZug=^TAbstractZug;
     TAbstractZug=OBJECT
                    Regler:TReglerFarbe;
                    name:string[MaxZugName+1];
                    CONSTRUCTOR init(r:TReglerFarbe; n:string);
                  END;

TYPE PZug=^TZug;
     TZug=OBJECT(TAbstractZug)
            CONSTRUCTOR init(r:TReglerFarbe; n:string);
            PROCEDURE Free;
            DESTRUCTOR done;  virtual;
            FUNCTION GetAnzahl:word;
            FUNCTION GetRec(welcher:word):PZugDatum;
            PROCEDURE DoAppend(wo:ROrt; an,ab:TZeit);
            PROCEDURE Delete(w:word);
            PROCEDURE GetTimeRange(VAR min,max:TZeit);
          PRIVATE
            Arr:TRecordArray; {Array ueber Records vom Typ RZugDatum}
          END;

{************************ Zugarray *****************************}

TYPE iZug=word;  {Index in TZugArray}

TYPE PZugArray=^TZugArray;
     TZugArray=OBJECT
                 CONSTRUCTOR init;
                 PROCEDURE Free;
                 DESTRUCTOR done;
                 FUNCTION GetAnzahl:word;
                 FUNCTION GetZug(welcher:iZug):PZug;
                 PROCEDURE MoveZug(VAR Zug:TZug);
                 FUNCTION GetZDP(zug:iZug; Datum:word):PZugDatum;
                 {FUNCTION Name2iZug(name:string):iZug;}
                 PROCEDURE GetBenutzteZeit(VAR anfang,ende:TZeit);
                 PROCEDURE GetReglerInBahnhof(node:PNode; VAR Farben:SReglerFarbe);
                 PROCEDURE DeleteZug(w:word);
               PRIVATE
                 Arr:TDynArray;
               END;

IMPLEMENTATION

{********************************* Reglerfarben *********************************}

CONST Farben:array [TReglerFarbe] of string[MaxReglerFarbeName]
      =('keine', 'blau', 'braun', 'grau', 'gelb', 'violett');

FUNCTION GetReglerFarbeName(f:TReglerFarbe):string;
BEGIN
  GetReglerFarbeName:=farben[f];
END;

{*********************************** ZugArray ***********************************}

CONSTRUCTOR TZugArray.init;
BEGIN
  Arr.init;
END;

PROCEDURE TZugArray.Free;
VAR w:word;
BEGIN
  for w:=1 to arr.anzahl do dispose(PZug(arr.p^[w]),done);
  Arr.Free;
END;

DESTRUCTOR TZugArray.Done;
BEGIN
  Free;
  Arr.done;
END;

FUNCTION TZugArray.GetZug(welcher:word):PZug;
BEGIN
  arr.CheckIndex(welcher);
  GetZug:=arr.p^[welcher];
END;

PROCEDURE TZugArray.MoveZug(VAR Zug:TZug);
VAR neuZug:PZug;
    w:word;
BEGIN
  new(neuZug,init(Zug.Regler, Zug.Name));
  arr.Append(neuZug);
{
  neuZug^.arr.Erweiterung(Zug.arr.anzahl);
  for w:=1 to Zug.arr.anzahl do neuZug^.arr.p^[w]:=Zug.arr.p^[w];
}
  neuZug^.arr.p:=Zug.arr.p;
  neuZug^.arr.anzahl:=Zug.arr.anzahl;
  Zug.arr.anzahl:=0;  {Daten nicht freigeben, weil *move*!!!!!!}
  Zug.arr.p:=nil;     {is nicht schn, aber schnell}
END;

FUNCTION TZugArray.GetZDP(zug,datum:word):PZugDatum;
BEGIN
  GetZDP:=GetZug(zug)^.GetRec(datum);
END;

{
FUNCTION TZugArray.Name2iZug(name:string):iZug;
VAR i:iZug;
BEGIN
  for i:=1 to arr.anzahl do if name=GetZug(i)^.name then begin
    Name2iZug:=i;
    exit;
  end;
  Name2iZug:=0;
END;
}

PROCEDURE TZugArray.GetBenutzteZeit(VAR anfang,ende:TZeit);
VAR Zug:iZug;
    Zeit:TZeit;
BEGIN
  if arr.anzahl=0 then begin
    Anfang:=0;
    Ende  :=24*60-1;
  end else begin
    Anfang:=24*60;  {best case}
    Ende  :=0;
    for Zug:=1 to arr.anzahl do with GetZug(Zug)^ do begin
      Zeit:=GetRec(1)^.AbZeit;
      if Zeit<Anfang then Anfang:=Zeit;
      Zeit:=GetRec(arr.anzahl)^.AnZeit;
      if Zeit>Ende then Ende:=Zeit;
    end;
    if Anfang>Ende then runerror; {Kann nicht passieren, wenn mindestens ein
                                   Zug existiert}
  end;
END;

PROCEDURE TZugArray.GetReglerInBahnhof(node:PNode; VAR Farben:SReglerFarbe);
VAR z:iZug;
    zd:word;
    zp:PZug;
    zdp:PZugDatum;
BEGIN
  Farben:=[];
  for z:=1 to arr.anzahl
    do with GetZug(z)^
      do for zd:=1 to arr.anzahl
        do with GetRec(zd)^
          do if Ort.Knoten=Node then Farben:=Farben+[Regler];
END;

FUNCTION TZugArray.GetAnzahl:word;
BEGIN
  GetAnzahl:=Arr.Anzahl;
END;

PROCEDURE TZugArray.DeleteZug(w:word);
BEGIN
  dispose(GetZug(w),done);
  arr.delete(w);
END;

{************************************* Zug **************************************}

CONSTRUCTOR TAbstractZug.init(r:TReglerFarbe; n:string);
BEGIN
  Regler:=r;
  Name:=n;
END;

CONSTRUCTOR TZug.init(r:TReglerFarbe; n:string);
BEGIN
  inherited init(r,n);
  arr.init(sizeof(RZugDatum));
END;

FUNCTION TZug.GetRec(welcher:word):PZugDatum;
BEGIN
  arr.checkindex(welcher);
  GetRec:=arr.p^[welcher];
END;

DESTRUCTOR TZug.done;
BEGIN
  Free;
END;

PROCEDURE TZug.Free;
BEGIN
  arr.done;
END;

PROCEDURE TZug.DoAppend(wo:ROrt; an,ab:TZeit);
VAR zdp:PZugDatum;
BEGIN
  new(zdp);
  zdp^.ort:=wo;
  zdp^.anZeit:=an;
  zdp^.abZeit:=ab;
  arr.Append(zdp);
END;

FUNCTION TZug.GetAnzahl:word;
BEGIN
  GetAnzahl:=Arr.Anzahl;
END;

PROCEDURE TZug.Delete(w:word);
BEGIN
  arr.delete(w);
END;

PROCEDURE TZug.GetTimeRange(VAR min,max:TZeit);
BEGIN
  min:=GetRec(1)^.AbZeit;
  max:=GetRec(GetAnzahl)^.AnZeit;
END;

END.