{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: ExecuteZugListeDialog fuehrt ein Dialogfenster aus, mit dem
         man Namen und Farben der Zuege aendern und Zuege loeschen kann.
         3.8.95: Nahezu rewritten: objektorientierter, cancelbutton,
         zugloeschen umkehrbar.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}

UNIT ZugList;

INTERFACE
USES Wintypes, MDIchild, oWindows, oDialogs, Objects;

FUNCTION ExecuteZugListeDialog(parent:PWindowsObject):boolean;


IMPLEMENTATION
USES Daten, ZugArr, LineArr, Ort_Zeit, RFarben, FarbDlg, Optionen,
     WinProcs, Win_Allg, grund, BWCC, heap, Strings;


{****************************** KopieArray *****************************}

TYPE PListenZug=^TListenZug;
     TListenZug=OBJECT(TAbstractZug)
                  Deleted:boolean;
                END;

TYPE TKopie=OBJECT(TDynArray)
              CONSTRUCTOR init;        {Erstellt die Kopie vom Zugarray}
              PROCEDURE Free; virtual; {Gibt den Speicher Frei}
              PROCEDURE Update;        {Aendert das Zugarray wie editiert}
              FUNCTION GetRec(nr:word):PListenZug;
            END;

CONSTRUCTOR TKopie.init;
VAR w:word;
    q:PAbstractZug;
    z:PListenZug;
BEGIN
  inherited init;
  Erweiterung(FahrplanDaten.ZugArray^.GetAnzahl);
  for w:=1 to Anzahl do begin
    q:=FahrplanDaten.ZugArray^.GetZug(w);
    new(z);
    with z^ do begin
      Name:=q^.Name;
      Regler:=q^.Regler;
      Deleted:=false;
    end;
    p^[w]:=z;
  end;
END;

PROCEDURE TKopie.Free;
VAR w:word;
BEGIN
  for w:=1 to anzahl do dispose(PListenZug(p^[w]));
  inherited Free;
END;

PROCEDURE TKopie.Update;
VAR w:word;
    z:PAbstractZug;
    q:PListenZug;
BEGIN
  for w:=anzahl downto 1 do begin
    q:=GetRec(w);
    if q^.Deleted then FahrplanDaten.ZugArray^.DeleteZug(w)
    else begin
      z:=FahrplanDaten.ZugArray^.GetZug(w);
      z^.Name:=q^.Name;
      z^.Regler:=q^.Regler;
    end;
  end;
END;

FUNCTION TKopie.GetRec(nr:word):PListenZug;
BEGIN
  CheckIndex(nr);
  GetRec:=p^[nr];
END;

{***************************** Dialogfenster****************************}

CONST id_listbox=101;
      id_zugname=111;
      id_reglerfarbe=112;
      id_zuglauf=113;
      id_laufzeit=114;
      id_reglerfarbeaendern=103;
      id_LoeschZug=107;

TYPE PZugListe=^TZugListe;
     TZugListe=OBJECT(TDialog)
                  Angewaehlt:word; {Index des angewaehlten Zuges, keiner=0}
                  Kopie:TKopie;
                  ListBox:PListBox;
                  ZugName:PEdit;
                  ReglerFarbe:PStatic;
                  LoeschZug:PCheckBox;
                  CONSTRUCTOR init(aparent:PWindowsObject);
                  DESTRUCTOR done;              virtual;
                  PROCEDURE SetupWindow;        virtual;
                  PROCEDURE Refresh_Listbox;
                  PROCEDURE Refresh_Data;
                  FUNCTION UpdateZugname:boolean;
                  PROCEDURE IDListBox(VAR Msg:TMessage); virtual id_first+id_listbox;
                  PROCEDURE IDreglerfarbeaendern(VAR Msg:TMessage); virtual id_first+id_reglerfarbeaendern;
                  PROCEDURE IDLoeschzug(VAR Msg:TMessage); virtual id_first+id_LoeschZug;
                  PROCEDURE IDHilfe    (VAR Msg:TMessage); virtual id_first+998;
                  PROCEDURE OK(VAR Msg:TMessage); virtual id_first+id_ok;
                END;

CONSTRUCTOR TZugListe.init(aparent:PWindowsObject);
BEGIN
  inherited init(aparent, 'ZugListe');
  Angewaehlt:=0;
  Kopie.Init;
  new(ListBox, initresource(@self, id_listbox));
  new(ZugName, initresource(@self, id_ZugName, MaxZugName-1));
  new(ReglerFarbe, initresource(@self, id_ReglerFarbe, 10));
  new(LoeschZug, initresource(@self, id_LoeschZug));
END;

DESTRUCTOR TZugListe.done;
BEGIN
  inherited done;
  Kopie.done;
END;

PROCEDURE TZugListe.SetupWindow;
BEGIN
  inherited SetupWindow;
  Refresh_ListBox;
  Refresh_Data;
END;

PROCEDURE TZugListe.Refresh_Listbox;
VAR w:word;
    s:string;
BEGIN
  ListBox^.ClearList;
  for w:=1 to Kopie.Anzahl do with Kopie.GetRec(w)^ do begin
    if Deleted then s:='('+name+')'
               else s:=name;
    s:=s+space(20-length(s))+tab+GetReglerFarbeName(Regler)+#0;
    ListBox^.AddString(@s[1]);
  end;
  listbox^.setselindex(integer(Angewaehlt)-1);
END;

PROCEDURE TZugListe.Refresh_Data;
VAR l:longint;
    ZugNamePuffer:string[50];
    ReglerName:string[20];
    ZugLauf:string[100];
    Loeschen:boolean;
    w:word;
    AendernBtn,LoeschBtn:hwnd;
    LaufZeit:string[25];
    IsWasAngewaehlt:boolean;
    Zug:PZug;
BEGIN
{retten}
  UpdateZugname;
{neu beschreiben}
  AendernBtn:=GetDlgItem(hwindow, id_ReglerFarbeAendern);
  l:=SendDlgItemMsg(id_listbox, lb_GetCurSel, 0, 0);
  IsWasAngewaehlt:=(l>=0) and (l<Kopie.Anzahl);
  if IsWasAngewaehlt then begin
    Angewaehlt:=l+1;
    Zug:=FahrplanDaten.ZugArray^.GetZug(Angewaehlt);
    ZugLauf:='';
    for w:=1 to Zug^.GetAnzahl do
      ZugLauf:=ZugLauf+Zug^.GetRec(w)^.ort.Knoten^.Bahnhof.Daten.KurzName+' - ';
    if Zug^.GetAnzahl<>0 then dec(byte(ZugLauf[0]),3);
    ZugLauf:=ZugLauf+#0;
    LaufZeit:=Zeit2hmin(Zug^.GetRec(1)^.AbZeit,true)+' - '+
              Zeit2hmin(Zug^.GetRec(Zug^.GetAnzahl)^.AnZeit,true)+#0;
    with Kopie.GetRec(Angewaehlt)^ do begin
      ZugNamePuffer:=Name+#0;
      ReglerName:=GetReglerFarbeName(Regler)+#0;
      Loeschen:=Deleted;
    end;
  end else begin
    Angewaehlt:=0;
    ZugNamePuffer:=#0;
    ReglerName:=#0;
    ZugLauf:=#0;
    LaufZeit:=#0;
    Loeschen:=false;
  end;
  ZugName^.SetText(@ZugNamePuffer[1]);
  ReglerFarbe^.SetText(@ReglerName[1]);
  SetWindowText(GetDlgItem(hwindow,id_zuglauf), @ZugLauf[1]);
  SetWindowText(GetDlgItem(hwindow,id_laufzeit), @LaufZeit[1]);
  LoeschZug^.SetCheck(word(Loeschen));
  EnableWindow(ZugName^.hWindow, IsWasAngewaehlt);
  EnableWindow(GetDlgItem(hWindow, id_ReglerFarbeAendern), IsWasAngewaehlt);
  EnableWindow(LoeschZug^.hWindow, IsWasAngewaehlt);
END;

FUNCTION TZugListe.UpdateZugname:boolean;  {true=Daten haben sich geaendert}
VAR Buffer:string[MaxZugName+1];
    w:word;
    DatenUebernehmen:boolean;
    FehlerMeldung:string;
    geaendert:boolean;
BEGIN
  geaendert := (Angewaehlt<>0) and (ZugName^.IsModified);
  UpdateZugname:=geaendert;
  if geaendert then begin
    DatenUebernehmen:=false;
    Zugname^.ClearModify;
    Buffer[0]:=char(ZugName^.GetText(@Buffer[1], MaxZugName-1));
    if Length(Buffer)=0 then begin
      MessageBox(hWindow,
                 'Zugname darf nicht eine Lnge von 0 haben!'+cr+
                 'Der vorherige Name wird restauriert.',
                 'Hopla',
                 mb_OK+mb_IconHand);
    end else begin
      DatenUebernehmen:=true;
      if Autocheck.GetValue then begin
        w:=0;
        while (w<Kopie.anzahl) and DatenUebernehmen do begin
          inc(w);
          if (w<>angewaehlt) and (Buffer=Kopie.GetRec(w)^.Name) then begin
            FehlerMeldung:='Zge #'+zahlstr(w,1)+' und #'+zahlstr(Angewaehlt,1)+' haben jetzt den gleichen Namen.'+cr+
                           'Woll''n wa dat nu so lassen?'+#0;
            DatenUebernehmen := (MessageBox(hWindow, @FehlerMeldung[1], 'Daten inkonsistent!', mb_OKCancel)=id_OK);
          end;
        end;
      end;
    end;
    if DatenUebernehmen then begin
      Kopie.GetRec(Angewaehlt)^.Name:=Buffer
    end else begin
      Buffer:=Kopie.GetREc(Angewaehlt)^.Name+#0;
      ZugName^.SetText(@Buffer[1]);
    end;
  end;
END;

PROCEDURE TZugListe.IDreglerfarbeaendern(VAR Msg:TMessage);
VAR Edit:TReglerFarbe;
    Start,Stop:TZeit;
    EditierterZug, LaufZug:PZug;
    w:word;
    FehlerMeldung:string;
    DatenUebernehmen:boolean;
BEGIN
  if UpdateZugname then Refresh_Listbox;

  if Angewaehlt=0 then exit;
  Edit:=Kopie.GetRec(Angewaehlt)^.Regler;
  ExecuteReglerFarbeDialog(@self, Edit);
  DatenUebernehmen:=true;
  if (Edit<>Kopie.GetRec(Angewaehlt)^.Regler) and AutoCheck.GetValue then begin
    EditierterZug:=FahrplanDaten.ZugArray^.GetZug(Angewaehlt);
    Start:=EditierterZug^.GetRec(1)^.AbZeit;
    Stop:=EditierterZug^.GetRec(EditierterZug^.GetAnzahl)^.AnZeit;
    w:=0;
    while (w<Kopie.Anzahl) and DatenUebernehmen do begin
      inc(w);
      if w<>Angewaehlt then begin
        LaufZug:=FahrplanDaten.ZugArray^.GetZug(w);
        if (LaufZug^.Regler=Edit) and
           (LaufZug^.GetRec(1)^.AbZeit < Stop) and
           (Start < LaufZug^.GetRec(LaufZug^.GetAnzahl)^.AnZeit) then begin
          FehlerMeldung:='Jetzt berschneiden sich "'+EditierterZug^.Name+'" und "'+LaufZug^.Name+'", zeitlich, '+
                         'obwohl sie die gleiche Farbe haben!'+cr+
                         'Aber, wenn das so sein mu...'+#0;
          DatenUebernehmen:=(MessageBox(hWindow, @FehlerMeldung[1], 'Daten inkonsistent!', mb_OKCancel) = id_OK);
        end;
      end;
    end;
  end;
  if DatenUebernehmen then begin
    Kopie.GetRec(Angewaehlt)^.Regler:=Edit;
    Refresh_Listbox;
    Refresh_Data;
  end;
END;

PROCEDURE TZugListe.IDListBox(VAR Msg:TMessage);
VAR geaendert:boolean;
BEGIN
  case Msg.LparamHi of
    lbn_DblClk   :;
    lbn_SelChange:begin
                    geaendert:=UpdateZugname;
                    Refresh_Data;
                    if geaendert then Refresh_Listbox;
                  end;
  end;
END;

PROCEDURE TZugListe.IDLoeschZug(VAR Msg:TMessage);
BEGIN
  if (Angewaehlt=0) or (Msg.lParamHi<>bn_clicked) then exit;
  Kopie.GetRec(Angewaehlt)^.Deleted:=boolean(LoeschZug^.GetCheck);
  UpdateZugname;
  Refresh_Listbox;
END;

PROCEDURE TZugListe.IDHilfe(VAR Msg:TMessage);
BEGIN
  Hilfe(keineHilfe);
END;

PROCEDURE TZugListe.OK(VAR Msg:TMessage);
VAR w:word;
    anz:word;
    txt:array [0..100] of char;
BEGIN
  UpdateZugname;
  anz:=0;
  for w:=1 to Kopie.Anzahl do if Kopie.GetRec(w)^.Deleted then inc(anz);
  if (anz>0) then begin
    wvsprintf(txt, 'Sie haben %d Zge zum lschen markiert! Lschen druchfhren?', anz);
    if (BWCCMessageBox(hWindow, txt, 'Wiiiiiirklich?', mb_OkCancel or mb_iconquestion)<>id_ok) then exit;
  end;
  Kopie.Update;
  inherited ok(msg);
END;


FUNCTION ExecuteZugListeDialog(parent:PWindowsObject):boolean;
VAR dlg:TZugListe;
    ok:boolean;
BEGIN
  if FahrplanDaten.ZugArray^.GetAnzahl=0
  then BWCCmessagebox(parent^.hwindow, 'Malen sie erst einmal ein paar Zge in den Fahrplan, dann sehen wir weiter...',
                                       '- keine Zugliste -', mb_ok+mb_iconhand)
  else begin
    dlg.init(parent);
    ok:= (dlg.execute=id_ok);
    ExecuteZugListeDialog:=ok;
    if ok then FahrplanDaten.ZuegeVeraendert;
    dlg.done;
  end;
END;


END.
