{Projekt: FAHRPLAN

 Autor: Stefan Bormann 95

 Inhalt: ExecuteZuegeVerschieben fhrt ein Dialogfenster aus, dass es
         dem Anwender erlaubt, eine Menge von Zgen komplett in der Zeit
         zu verschieben.
}

{$A+,B-,D+,F-,G+,I+,K-,L+,N+,P+,V+,W-,X+,Y+}
{$Q+,R+,S+,T+}


UNIT ZugVersc;

INTERFACE
USES oWindows;

FUNCTION ExecuteZuegeVerschieben(parent:PWindowsObject):boolean;


IMPLEMENTATION
USES oDialogs, WinProcs, WinTypes, Daten, ZugArr, base_wnd, Ort_Zeit, grund;

CONST id_ListBox=201;
      id_Edit=301;
      id_alle=101;
      id_keiner=102;
      id_static=103;

TYPE TZuegeVerschieben=OBJECT(TDialog)
                         ListBox:PListBox;
                         Static:PStatic;
                         Edit:PNumericEdit;
                         CONSTRUCTOR init(aparent:PWindowsObject);
                         PROCEDURE SetupWindow; virtual;
                         PROCEDURE UpdateStatic;
                         PROCEDURE IDalle(VAR Msg:TMessage);   virtual id_first+id_alle;
                         PROCEDURE IDkeiner(VAR Msg:TMessage); virtual id_first+id_keiner;
                         PROCEDURE IDlistbox(VAR Msg:TMessage); virtual id_first+id_listbox;
                         PROCEDURE OK(VAR Msg:TMessage);       virtual id_first+id_ok;
                       END;

CONSTRUCTOR TZuegeVerschieben.init(aparent:PWindowsObject);
CONST highest=24*60 -1;
BEGIN
  inherited init(aparent, 'ZuegeVerschieben');
  new(ListBox, initresource(@self, id_ListBox));
  new(Static,  initresource(@self, id_Static, 42));
  new(Edit,    initresource(@self, id_Edit, -highest, +highest, 5));
END;

PROCEDURE TZuegeVerschieben.SetupWindow;
VAR w:word;
    Puffer:string[MaxZugName+1];
BEGIN
  inherited SetupWindow;
  for w:=1 to Fahrplandaten.ZugArray^.GetAnzahl do begin
    Puffer:=Fahrplandaten.ZugArray^.GetZug(w)^.Name+#0;
    ListBox^.AddString(@Puffer[1]);
  end;
  UpdateStatic;
  Edit^.SetText('0');
END;

PROCEDURE TZuegeVerschieben.UpdateStatic;
VAR r:record
        angewaehlt:word;
        von:word;
      end;
    Puffer:array [0..42] of char;
BEGIN
  r.angewaehlt:=loword(SendDlgItemMsg(id_Listbox, lb_getselcount, 0, 0));
  r.von:=FahrplanDaten.ZugArray^.GetAnzahl;
  wvsprintf(puffer, '%d von %d', r);
  Static^.SetText(puffer);
END;

PROCEDURE TZuegeVerschieben.IDalle(VAR Msg:TMessage);
BEGIN
  SendDlgItemMsg(id_Listbox, lb_setsel, 1, -1);
  UpdateStatic;
END;

PROCEDURE TZuegeVerschieben.IDkeiner(VAR Msg:TMessage);
BEGIN
  SendDlgItemMsg(id_Listbox, lb_setsel, 0, -1);
  UpdateStatic;
END;

PROCEDURE TZuegeVerschieben.IDlistbox(VAR Msg:TMessage);
BEGIN
  UpdateStatic;
END;

PROCEDURE TZuegeVerschieben.OK(VAR Msg:TMessage);
VAR Differenz:integer;
    w,d:word;
    Zug:PZug;
    Abstand:word;
    neu:word;
    DieAnzahl:longint;
    Meldung:string;
BEGIN
  if not Edit^.CanClose then exit;
  Edit^.GetValue(Differenz);
  if Differenz=0 then begin
    Messagebox(hWindow,
               'Aha, du willst also Zge um gigantische 0 Minuten verschieben! Wie aufregend!',
               'Hihihihi',
               mb_OK);
    exit;
  end;
  DieAnzahl:=SendDlgItemMsg(id_Listbox, lb_getselcount, 0, 0);
  if (DieAnzahl<1) or (DieAnzahl>FahrplanDaten.ZugArray^.GetAnzahl) then begin
    Messagebox(hWindow,
               'Du hast keine Zge angewhlt!!! Welcher soll denn nun verschoben werden???',
               'Du Schmied!',
               mb_ok);
    exit;
  end;
  Abstand:=$FFFF;
  for w:=1 to FahrplanDaten.ZugArray^.GetAnzahl do begin
    if SendDlgItemMsg(id_Listbox, lb_GetSel, w-1, 0)>0 then begin
      Zug:=FahrplanDaten.ZugArray^.GetZug(w);
      if Differenz<0 then neu:=Zug^.GetRec(1)^.AbZeit
                     else neu:=MaxZeit-Zug^.GetRec(Zug^.GetAnzahl)^.AnZeit;
      Abstand:=min(Abstand, neu);
    end;
  end;
  if Abstand=$FFFF then runerror;
  if Abstand<abs(Differenz) then begin
    if Differenz>0 then Meldung:='Du hast versucht, einen Zug so weit in den Abend zu verschieben, '+cr+
                                 'da er nach 24 Uhr ankme!'+#0
                   else Meldung:='Du hast versucht, einen Zug so weit in die Frhe zu verschieben, '+cr+
                                 'da er vor 0 Uhr ankme!'+#0;
    Messagebox(hWindow, @Meldung[1], 'Sooo geht das leider nicht!', mb_ok);
    exit;
  end;
  if Differenz>0 then Meldung:='den Abend'
                 else Meldung:='die Fruehe';

  Meldung:='Du willst also '+zahlstr(DieAnzahl,1)+' Zg(e) um '+zahlstr(abs(Differenz),1)+'min in '+Meldung+' verschieben.'+cr+
           'Achtung! Es findet kein automatischer Check der Datenintegritt statt.'+#0;
  if MessageBox(hWindow, @Meldung[1], 'Aha', mb_OkCancel or mb_IconExclamation) <> id_OK then exit;
  for w:=1 to FahrplanDaten.ZugArray^.GetAnzahl do
    if SendDlgItemMsg(id_Listbox, lb_GetSel, w-1, 0)>0 then
      with Fahrplandaten.ZugArray^.GetZug(w)^ do
        for d:=1 to GetAnzahl do
          with GetRec(d)^
  do begin
    inc(AbZeit, Differenz);
    inc(AnZeit, Differenz);
  end;
  inherited ok(msg);
END;


FUNCTION ExecuteZuegeVerschieben(parent:PWindowsObject):boolean;
VAR dlg:TZuegeVerschieben;
    ok:boolean;
BEGIN
  if FahrplanDaten.ZugArray^.GetAnzahl=0 then begin
    MessageBox(parent^.hWindow,
               'Bevor Zge verschoben werden knnen, mssen sie erstmal existieren',
               'Bldmann! Aber netter Versuch...',
               mb_OK);
    exit;
  end;
  dlg.init(parent);
  ok:=(dlg.execute=id_OK);
  ExecuteZuegeVerschieben:=ok;
  if ok then FahrplanDaten.ZuegeVeraendert;
  dlg.done;
END;


END.
