/**
 * @file avmaic_board_params.h
 *
 * AvmAic-BoardParameters - Board parameter definitions for IX1A ISDN adapters.
 *
 * Copyright: 2005 Thomas Wintergerst. All rights reserved.
 *
 * $Id: avmaic_board_params.h,v 1.1.2.1 2005/05/27 16:28:06 thomas Exp $
 * $Project:    CAPI for BSD $
 * $Target:     AVM active ISDN boards control program $
 * @date        13.03.2005
 * @author      "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __AVMAIC_BOARD_PARAMS_H
#define __AVMAIC_BOARD_PARAMS_H





/* === Public declarations =============================================== */





/** The maximum length for a D-channel protocol specification string. */
#define AVMAIC_DPROT_LEN        16

/** The length of SPIDs for north american D-channel protocols. */
#define AVMAIC_SPID_LEN         20

/** The length of DN number for north american D-channel protocols. */
#define AVMAIC_DN_LEN           16



/**
 * The summation of board parameters to send to the controller.
 */
typedef struct
{
   char     szDProtocol [AVMAIC_DPROT_LEN];
                                /**< The D-channel protocol to use. */
   int      fP2P;               /**<
                                 * - 1
                                 *    Line is configured for Point-to-Point
                                 *    operation (direct dial-in).
                                 * - 0
                                 *    Line is configured for multipoint
                                 *    operation (MSN).
                                 */
   unsigned uTeiValue;          /**< For P2P: The TEI value to use. */
   char     szSpid1 [AVMAIC_SPID_LEN];
                                /**<
                                 * Only for D-channel protocols 5ESS and NI1:
                                 * SPID for the 1st B-channel.
                                 */
   char     szDn1 [AVMAIC_DN_LEN];
                                /**<
                                 * Only for D-channel protocols 5ESS and NI1:
                                 * Directory number for the 1st B-channel.
                                 */
   char     szSpid2 [AVMAIC_SPID_LEN];
                                /**<
                                 * Only for D-channel protocols 5ESS and NI1:
                                 * SPID for the 2nd B-channel.
                                 */
   char     szDn2 [AVMAIC_DN_LEN];
                                /**<
                                 * Only for D-channel protocols 5ESS and NI1:
                                 * Directory number for the 2nd B-channel.
                                 */
} AvmaicBoardParameters_t;





/* === Prototypes of interface functions ================================= */





#endif /* __AVMAIC_BOARD_PARAMS_H */
