/**
 * @file avmaic_cfgdefs.h
 *
 * AvmAic-ConfigDefinitions - Section and key names for an AVM active ISDN
 * controller configuration file.
 *
 * Copyright: 2005 Thomas Wintergerst. All rights reserved.
 *
 * $Id: avmaic_cfgdefs.h,v 1.4.2.1 2005/05/27 16:28:06 thomas Exp $
 * $Project:    CAPI for BSD $
 * $Target:     AVM active ISDN boards control program $
 * @date        14.03.2005
 * @author      "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef AVMAIC_CFGDEFS_H
#define AVMAIC_CFGDEFS_H





// === Public declarations ===============================================





/// @name Section names for the configuration file
/// @{

/// The name of the boards sub-section for the line ports, must be completed
/// with the (1-based) port index number.
#define AVMAIC_CFG_SECT_PORT            "port-"

/// @}



/// @name Key names for the board sections of the configuration file
/// @{

/// The key string for the firmware code file name.
#define AVMAIC_CFG_KEY_FIRMWARE_FILE    "Firmware"

/// @}



/// @name Key names for a port's line access parameters section
/// @{

/// The key string for the D-channel protocol.
#define AVMAIC_CFG_KEY_DPROTOCOL        "DProtocol"

/// The key string for the Point-to-Point setting.
#define AVMAIC_CFG_KEY_P2P              "P2P"

/// The key string for the TEI value.
#define AVMAIC_CFG_KEY_TEI_VALUE        "TEI"

/// The key string for the SPID for the 1st B-channel.
#define AVMAIC_CFG_KEY_SPID1            "Spid1"

/// The key string for the DN for the 1st B-channel.
#define AVMAIC_CFG_KEY_DN1              "Dn1"

/// The key string for the SPID for the 2nd B-channel.
#define AVMAIC_CFG_KEY_SPID2            "Spid2"

/// The key string for the SPID for the 2nd B-channel.
#define AVMAIC_CFG_KEY_DN2              "Dn2"

/// @}



/// @name Comment strings for section names for the configuration file
/// @{

/// The name of the boards sub-section for the line ports, must be completed
/// with the (1-based) port index number.
#define IX1A_COMMENT_SECT_PORT \
   ";\n" \
   "; Line port specific settings\n" \
   ";\n"

/// @}



/// @name Comment strings for keys of the board sections of the configuration file
/// @{

/// The key string for the firmware code file name.
#define AVMAIC_COMMENT_KEY_FIRMWARE_FILE \
   ";\n" \
   "; The name of the firmware file for the board, must be an absolut path name.\n"

/// @}



/// @name Comment strings for keys of a port's line access parameters section
/// @{

/// The key string for the D-channel protocol.
#define AVMAIC_COMMENT_KEY_DPROTOCOL \
   ";\n" \
   "; D-channel protocol to use. One of:\n" \
   "; DSS1, D64S, D64S2, D64SD, DS01, DS02, CT1, VN3, AUSTEL, 5ESS, NI1, GSM,\n" \
   "; 1TR6, T1\n"

/// The key string for the Point-to-Point setting.
#define AVMAIC_COMMENT_KEY_P2P \
   ";\n" \
   "; Line access:\n" \
   "; 0=Multipoint operation (MSN lines)\n" \
   "; 1=Point-to-Point operation (direct dial-in lines)\n"

/// The key string for the TEI value.
#define AVMAIC_COMMENT_KEY_TEI_VALUE \
   ";\n" \
   "; Only for Point-to-Point operation: The TEI value to use, normally 0.\n"

/// The key string for the SPID of the 1st B-channel.
#define AVMAIC_COMMENT_KEY_SPID1        ";\n"

/// The key string for the directory number of the 1st B-channel.
#define AVMAIC_COMMENT_KEY_DN1          ";\n"

/// The key string for the SPID of the 2nd B-channel.
#define AVMAIC_COMMENT_KEY_SPID2        ";\n"

/// The key string for the directory number of the 2nd B-channel.
#define AVMAIC_COMMENT_KEY_DN2          ";\n"

/// @}





// === Class declarations ================================================





// === Prototypes of interface functions =================================





#endif /* AVMAIC_CFGDEFS_H */
