/**
 * @file capiutil.h
 *
 * CapiUtil - Utility functions to handle CAPI messages.
 *
 * Copyright: 2000-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: capiutil.h,v 1.7.4.1 2005/05/27 16:28:11 thomas Exp $
 * Project  CAPI for BSD
 * Target   capitest - Test tool for the functionality of CAPI for BSD
 * @date    01.01.2000
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __CAPIUTIL_H
#define __CAPIUTIL_H

#include <stddef.h>     // size_t
#include <string>
#include <capi20.h>





/* === public declarations =============================================== */





/* === prototypes of interface functions ================================= */





// --- Translate some identifiers and values to strings ---

/**
 * Translate a CAPI message base command into a string.
 */
const char *CapiUt_GetCapiMsgCmdName
   (unsigned uCmd);

/**
 * Translate a CAPI message sub command into a string.
 */
const char *CapiUt_GetCapiMsgSubCmdName
   (unsigned uCmd);



/* --- extracting data from CAPI messages --- */

/**
 * Store the called party number into a character array.
 */
unsigned char *CapiUt_ExtractCalledPartyNumber
   (unsigned char *pOrgPos,
    char          *pszCalledPartyNumber,
    size_t         nLenCalledPartyNumber);
    
/**
 * Store the called party number into an STL string.
 */
unsigned char *CapiUt_ExtractCalledPartyNumber
   (unsigned char *pOrgPos,
    std::string   &strCalledPartyNumber);
    
/**
 * Store the calling party number into a character array.
 */
unsigned char *CapiUt_ExtractCallingPartyNumber
   (unsigned char *pOrgPos,
    char          *pszCallingPartyNumber,
    size_t         nLenCallingPartyNumber);
    
/**
 * Store the calling party number into a character array.
 */
unsigned char *CapiUt_ExtractCallingPartyNumber
   (unsigned char *pOrgPos,
    std::string   &strCallingPartyNumber);
    
    
    
/* --- enter some CAPI structures into CAPI messages --- */

/* enter an empty CAPI structure at specified position */
unsigned char *CapiUt_EnterEmptyStruct
   (unsigned char *pOrgPos);
   
/* enter a string into a CAPI structure at specified position */
unsigned char *CapiUt_EnterString
   (unsigned char *pOrgPos,
    const char    *pszString);
    
/* enter the called party number at specified position */
unsigned char *CapiUt_EnterCalledPartyNumber
   (unsigned char *pOrgPos,
    const char    *pszNumber);
    
/* enter the calling party number at specified position */
unsigned char *CapiUt_EnterCallingPartyNumber
   (unsigned char *pOrgPos,
    const char    *pszNumber);
    




#endif /* __CAPIUTIL_H */
