/**
 * @file control.h
 *
 * Control - Control the requested actions for capitest.
 *
 * Copyright: 2000-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: control.h,v 1.7.4.1 2005/05/27 16:28:12 thomas Exp $
 * Project  CAPI for BSD
 * Target   capitest - Test tool for the functionality of CAPI for BSD
 * @date    01.01.2000
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __CONTROL_H
#define __CONTROL_H





// === public declarations ===============================================





// === declaration of classes ============================================





// === prototypes of interface functions =================================





/**
 * List all controllers installed.
 */
extern int Ctrl_ListAllControllers
   (bool fVerboseOutput);
   
/**
 * Do one or a series of self connections.
 */
extern int Ctrl_SelfConnect
   (bool fRepeat);
   
/**
 * Handle all incoming calls.
 */
extern int Ctrl_HandleIncomingCalls (void);
   
/**
 * Do one or a repeated series of identical outgoing calls.
 */
extern int Ctrl_DoOutgoingCalls
   (bool fRepeat);

/**
 * Do one or a repeated batch of outgoing calls.
 */
extern int Ctrl_DoBatchCalls
   (const std::string &strBatchFileName,
    bool               fRepeat);





#endif // __CONTROL_H
