/**
 * @file trace_file_header.h
 *
 * TraceFileHeader - Definition of the header information of a CAPI trace file.
 *
 * Copyright: 2002-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: trace_file_header.h,v 1.4.4.1 2005/05/27 16:28:14 thomas Exp $
 * Project  CAPI for BSD
 * Target   capitrace - Tracing CAPI calls and messages
 * @date    22.09.2002
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __TRACE_FILE_HEADER_H
#define __TRACE_FILE_HEADER_H

#include <capidef.h>





// === Public declarations ===============================================





/// The magic value declaring the file as a CAPI trace file (in machine byte
/// order, will be converted to little endian if needed).
#define TRACE_FILE_HEADER_MAGIC 0x43545243



/**
 * The header of a CAPI trace file.
 *
 * This header is written at the beginning of each CAPI trace file. Like every
 * CAPI definition each field of this structure is layed out according to the
 * Intel byte order (little endian).
 */
struct TraceFileHeader_t
{
   cDWORD dwMagic;              ///< The magic value identifying a trace file.
   cDWORD dwCtlrNum;            ///< The controller number the trace is created
                                ///< for. If the trace is an application trace,
                                ///< this value is zero (no valid ctlr. no.).
   cBYTE  bIncludeFctCalls;     ///< - 0: CAPI function calls not included.
                                ///< - Else: CAPI function calls included.
   cBYTE  bIncludeMessages;     ///< - 0: No CAPI messages included.
                                ///< - Else: General CAPI messages included.
   cBYTE  bIncludeDataB3Msgs;   ///< - 0: Data-B3 messages not included.
                                ///< - Else: Data-B3 messages included (only if
                                ///<    general CAPI messages are included).
   cBYTE  bIncludeDataB3Blocks; ///< - 0: No Data-B3 data blocks included.
                                ///< - Else: Data-B3 data blocks included (only
                                ///<    if Data-B3 messages are included).
   cWORD  wDataB3BlockLen;      ///< The maximum number of data block bytes
                                ///< written into the trace (only if data blocks
                                ///< are included).
   cDWORD dwTimeSeconds;        ///< The trace start time as delivered by
                                ///< gettimeofday(), seconds part.
   cDWORD dwTimeMicroSec;       ///< The trace start time as delivered by
                                ///< gettimeofday(), micro seconds part.
};





// === Class declarations ================================================





// === Prototypes of interface functions =================================





#endif // __TRACE_FILE_HEADER_H
