/**
 * @file daic_cfgdefs.h
 *
 * Daic-ConfigDefinitions - Section and key names for a Diehl legacy active
 * ISDN controller configuration file.
 *
 * Copyright: 2005 Thomas Wintergerst. All rights reserved.
 *
 * $Id: daic_cfgdefs.h,v 1.1.2.1 2005/05/27 16:28:19 thomas Exp $
 * $Project:    CAPI for BSD $
 * $Target:     Diehl legacy active ISDN boards control program $
 * @date        22.03.2005
 * @author      "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef DAIC_CFGDEFS_H
#define DAIC_CFGDEFS_H





// === Public declarations ===============================================





/// @name Section names for the configuration file
/// @{

/// The name of the section for global settings.
#define DAIC_CFG_SECT_GLOBAL            "global"

/// The name of the section for the boards.
#define DAIC_CFG_SECT_BOARDS            "boards"

/// @}



/// @name Key names for the global section of the configuration file
/// @{

/// The key string for the firmware base directory.
#define DAIC_CFG_KEY_BASE_DIRECTORY     "BaseDir"

/// @}



/// @name Key names for the boards' sections of the configuration file
/// @{

/// The key string for the D-channel protocol setting.
#define DAIC_CFG_KEY_DPROTOCOL          "DProtocol"

/// The key string for the line access setting (MP or P2P).
#define DAIC_CFG_KEY_NT2                "NT2"

/// The key string for the TEI value for P2P operation.
#define DAIC_CFG_KEY_TEI                "TEI"

/// The key string for the leased line setting.
#define DAIC_CFG_KEY_PERMANENT          "Permanent"

/// The key string for D-channel layer 2 setting.
#define DAIC_CFG_KEY_LAYER2             "Layer2"

/// The key string for the S2m B-channel selection setting.
#define DAIC_CFG_KEY_LOW_CHANNEL        "LowChannel"

/// The key string for setting the D-channel protocol version.
#define DAIC_CFG_KEY_PROTOCOL_VERSION   "ProtocolVersion"

/// The key string for the S2m CRC4 setting.
#define DAIC_CFG_KEY_CRC4               "CRC4"

/// The key string for the extensive memory test option.
#define DAIC_CFG_KEY_MEMORY_TEST        "MemoryTest"

/// The key string for the originating address of the 1st B-channel.
#define DAIC_CFG_KEY_OAD1               "OAD1"

/// The key string for the originating subaddress of the 1st B-channel.
#define DAIC_CFG_KEY_OSA1               "OSA1"

/// The key string for the SPID of the 1st B-channel.
#define DAIC_CFG_KEY_SPID1              "SPID1"

/// The key string for the originating address of the 2nd B-channel.
#define DAIC_CFG_KEY_OAD2               "OAD2"

/// The key string for the originating subaddress of the 2nd B-channel.
#define DAIC_CFG_KEY_OSA2               "OSA2"

/// The key string for the SPID of the 2nd B-channel.
#define DAIC_CFG_KEY_SPID2              "SPID2"

/// @}



/// @name Comment strings for section names for the configuration file
/// @{

/// The name of the section for global settings.
#define DAIC_COMMENT_SECT_GLOBAL \
   ";\n" \
   "; Global settings common to all boards\n" \
   ";\n"

/// The name of the section for the boards.
#define DAIC_COMMENT_SECT_BOARDS \
   ";\n" \
   "; Section containing all Diehl active ISDN boards\n" \
   ";\n"

/// @}



/// @name Comment strings for keys of the global section of the configuration file
/// @{

/// The key string for the firmware base directory.
#define DAIC_COMMENT_KEY_BASE_DIRECTORY \
   ";\n" \
   "; The directory for boot code and firmware files for Diehl active ISDN boards\n"

/// @}



/// @name Comment strings for keys of the boards' sections of the configuration file
/// @{

/// The key string for the D-channel protocol selection.
#define DAIC_COMMENT_KEY_DPROTOCOL \
   ";\n" \
   "; D-channel protocol to use. The string will select the firmware file to load.\n" \
   "; The firmware file name is constructed as \"te_<DProtocol>.<ext>\", e.g.\n" \
   "; \"te_etsi.sx\". The extension is selected through the board type.\n" \
   "; Note that case is significant.\n"

/// The key string for the line access setting (MP or P2P).
#define DAIC_COMMENT_KEY_NT2 \
   ";\n" \
   "; Line access setting.\n" \
   "; 0=Point-to-Multipoint, 1=Point-to-Point\n"

/// The key string for the TEI value.
#define DAIC_COMMENT_KEY_TEI \
   ";\n" \
   "; TEI value for fixed TEI setting (P2P). 0-63 are possible values.\n"

/// The key string for the leased line setting.
#define DAIC_COMMENT_KEY_PERMANENT \
   ";\n" \
   "; Select leased line mode.\n" \
   "; 0=switched line, 1=leased line\n"

/// The key string for the D-channel layer 2 setting.
#define DAIC_COMMENT_KEY_LAYER2 \
   ";\n" \
   "; D-channel layer 2 setting.\n" \
   "; 0=establish D-channel on demand, 1=no disconnect after\n" \
   "; establishment (default), 2=D-channel permanently active\n"

/// The key string for the S2m B-channel selection setting.
#define DAIC_COMMENT_KEY_LOW_CHANNEL \
   ";\n" \
   "; Number of the low B-channel to use.\n" \
   "; 0=default, 1-30 for the low B-channel to use\n"

/// The key string for setting the D-channel protocol version.
#define DAIC_COMMENT_KEY_PROTOCOL_VERSION \
   ";\n" \
   "; Protocol version selection.\n" \
   "; 0=default, the effect of other values is currently unknown\n"

/// The key string for the CRC4 setting.
#define DAIC_COMMENT_KEY_CRC4 \
   ";\n" \
   "; Setting to use CRC4 checksum for S2m boards.\n" \
   "; 0=default setting, 1=use CRC4, 2=disable CRC4\n"

/// The key string for performing extensive board memory test.
#define DAIC_COMMENT_KEY_MEMORY_TEST \
   ";\n" \
   "; Perform additional extensive board memory test (already performed at\n" \
   "; board initialisation time).\n" \
   "; 0=no memory check, 1=perform memory check on download\n"

/// The key string for the originating address for the 1st B-channel.
#define DAIC_COMMENT_KEY_OAD1           ""

/// The key string for the originating subaddress for the 1st B-channel.
#define DAIC_COMMENT_KEY_OSA1           ""

/// The key string for the SPID for the 1st B-channel.
#define DAIC_COMMENT_KEY_SPID1          ""

/// The key string for the originating address for the 2nd B-channel.
#define DAIC_COMMENT_KEY_OAD2           ""

/// The key string for the originating subaddress for the 2nd B-channel.
#define DAIC_COMMENT_KEY_OSA2           ""

/// The key string for the SPID of the 2nd B-channel.
#define DAIC_COMMENT_KEY_SPID2          ""

/// @}





// === Class declarations ================================================





// === Prototypes of interface functions =================================





#endif /* DAIC_CFGDEFS_H */
