/**
 * @file avmb1.h
 *
 * AvmB1 - Specific definitions for AVM-B1 ISA and PCI.
 *
 * Copyright: 2000-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: avmb1.h,v 1.8.2.1 2005/05/27 16:28:23 thomas Exp $
 * Project  CAPI for BSD
 * Target   avmaic - CAPI manager driver for AVM active ISDN controllers
 * @date    01.01.2000
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __AVMB1_H
#define __AVMB1_H





/* === public declarations =============================================== */





/* === prototypes of interface functions ================================= */





/* probe for a B1 ISA */
extern int avmb1_isa_probe              /* 0: card found
                                         * errno value: card not found,
                                         *    specified error occurred
                                         */
   (device_t dev);                      /* I: device data for the card to probe
                                         */

/* attach a B1 ISA */
extern int avmb1_isa_attach             /* 0: card successfully attached
                                         * errno value: error attaching card
                                         */
   (device_t dev);                      /* I: device data for the card to
                                         *    attach
                                         */

/* attach a B1 PCI v3 or v4 */
extern int avmb1_pci_attach             /* 0: card successfully attached
                                         * errno value: error attaching card
                                         */
   (device_t dev);

/**
 * Probe for a B1 PCMCIA / M1 / M2.
 *
 * The probe operation for these card types checks if the required i/o ports
 * and the irq is available. Additionally some check is made to check for a
 * working card.
 *
 * @param dev                   I: The device for the card to probe.
 * @param cardType              I: The card type to probe for (only B1 PCMCIA,
 *                                 M1 or M2 allowed).
 *
 * @retval 0                    The card device was found to work.
 * @retval Else                 The card device is not working or the resources
 *                              cannot be acquired. The result is an
 *                              appropriate errno value.
 */
extern int avmb1_pccard_probe
   (device_t         dev,
    AvmAicCardType_t cardType);

/**
 * Attach a B1 PCMCIA / M1 / M2 to its bus.
 *
 * @param dev                   I: The device for the card to attach.
 * @param cardType              I: The card type for the card to attach.
 *
 * @retval 0                    The card was successfully attached.
 * @retval Else                 Failure, the result is an appropriate errno
 *                              value.
 */

extern int avmb1_pccard_attach
   (device_t         dev,
    AvmAicCardType_t cardType);





/* === definition of inline functions ==================================== */





#endif /* __AVMB1_H */
