/**
 * @file avmlli.h
 *
 * AvmLLI - Low Level Interface for the AVM active board driver.
 *
 * Copyright: 2000-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: avmlli.h,v 1.8.4.1 2005/05/27 16:28:25 thomas Exp $
 * Project  CAPI for BSD
 * Target   avmaic - CAPI manager driver for AVM active ISDN controllers
 * @date    01.01.2000
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __AVMLLI_H
#define __AVMLLI_H

#include <capidef.h>





/* === Global declarations =============================================== */






/* --- LLI messages to the ISDN controller --- */

#define AVMAIC_WRITE_INTREG	0x00    /* write to internal register */
#define AVMAIC_READ_INTREG	0x01    /* read from internal register */
#define AVMAIC_SEND_INIT	0x11	/* first message to the controller
					 * after loading the software
					 * --> AVMAIC_RECEIVE_INIT
					 */
#define AVMAIC_SEND_REGISTER	0x12	/* register an application */
#define AVMAIC_SEND_DATA_B3_REQ	0x13	/* send capi message data-b3-req */
#define AVMAIC_SEND_RELEASE	0x14	/* deregister an application
					 * --> AVMAIC_RECEIVE_FREE_NCCI with
					 * NCCI 0xFFFFFFFF
					 */
#define AVMAIC_SEND_MESSAGE	0x15	/* send any capi message but
					 * data-b3-req
					 */
#define AVMAIC_SEND_CONFIG	0x21	/* change configuration of card sw */
#define AVMAIC_SEND_POLL	0x72	/* check function of i/o based card
                                         * after loading the software
					 * --> AVMAIC_RECEIVE_POLL
					 */
#define AVMAIC_SEND_POLLACK	0x73	/* check function of dma based card
                                         * after loading the software
                                         * --> AVMAIC_RECEIVE_POLLDWORD
                                         * 2nd function: acknowledge the receipt
                                         * of AVMAIC_RECEIVE_START for dma based
                                         * boards
                                         */



/* --- LLI messages from the ISDN controller --- */

#define AVMAIC_RECEIVE_MESSAGE		0x21
					/* any capi message but data-b3-ind is
					 * received
					 */
#define AVMAIC_RECEIVE_DATA_B3_IND	0x22
					/* capi message data-b3-ind is received
					 */
#define AVMAIC_RECEIVE_START		0x23
					/* handshake: the card is able to
					 * accept another outgoing capi message
					 */
#define AVMAIC_RECEIVE_STOP		0x24
					/* handshake: the card is not able to
					 * accept outgoing capi messages any
					 * more, state is cleared by
					 * AVMAIC_RECEIVE_START
					 */
#define AVMAIC_RECEIVE_NEW_NCCI		0x25
					/* tells the driver that the card has
					 * allocated a new logical connection
					 */
#define AVMAIC_RECEIVE_FREE_NCCI	0x26
					/* tells the driver that the card has
					 * freed a logical connection or
					 * released all connections and the
					 * complete application (argument NCCI
					 * is 0xFFFFFFFF)
					 */
#define AVMAIC_RECEIVE_INIT		0x27
					/* answer to AVMAIC_SEND_INIT, delivers
					 * several data about the controller
					 * and the software
					 */
#define AVMAIC_RECEIVE_TASK_READY	0x31
					/* ? */
#define AVMAIC_RECEIVE_POLL		0x32
					/* answer to AVMAIC_SEND_POLL */
#define AVMAIC_RECEIVE_DEBUGMSG		0x71
					/* ? */
#define AVMAIC_RECEIVE_POLLDWORD	0x75
					/* answer to AVMAIC_SEND_POLLACK */



/* --- data structures for arguments to the send and receive commands --- */

#include <capi_pack_on.h>

/* provide the controller with data for initialization */
typedef struct
{
   cDWORD dwNumApplications;    /* maximum number of applications
                                 * simultaneously registered at the controller
                                 */
   cDWORD dwNumNccis;           /* maximum number of simultaneously active
                                 * logical (B3) connections for an application
                                 */
   cDWORD dwBoardNumber;        /* driver specific CAPI controller number; if
                                 * possible it should be equal to the unique
                                 * CAPI controller number
                                 */
} AvmLliSendInit_t;

/* register an application at the controller */
typedef struct
{
   cDWORD dwApplID;             /* the appl. id assigned by the CAPI manager;
                                 * if more than dwNumApplications of
                                 * AvmLliSendInit_t are registered at the CAPI
                                 * manager, only the first ones may use this
                                 * controller
                                 */
   cDWORD dwSizeMsgBuffer;      /* == (dwNumB3Connections + 1) * 1024 */
   cDWORD dwNumB3Connections;   /* maximum no. B3 connections the application
                                 * wants to handle simultaneously
                                 */
   cDWORD dwNumB3Blocks;        /* maximum no. indicated B3 data blocks without
                                 * response (receive window for data blocks)
                                 */
   cDWORD dwB3Size;             /* maximum size of one B3 data block for send
                                 * and receive
                                 */
} AvmLliSendRegister_t;

/* send a data-b3-request to the controller */
/* unfortunately it is not possible to define a fixed structure for this */
/*
typedef struct
{
   cDWORD dwMsgLength;
   CAPI message inclusive length word
   cDWORD dwDataLength;
   Data-B3 block for the message
} AvmLliSendDataB3Request_t;
*/

/* release an application at the controller */
typedef struct
{
   cDWORD dwApplID;             /* appl. id to release assigned by the CAPI
                                 * manager (see also note in
                                 * AvmLliSendRegister_t)
                                 */
} AvmLliSendRelease_t;

/* send a CAPI message (but no data-b3-request) to the controller */
typedef struct
{
   cDWORD dwLength;
   /* and here comes the full CAPI message inclusive length word */
} AvmLliSendMessage_t;

/* receive a CAPI message (but not a data-b3-indication) from the controller */
typedef struct
{
   cDWORD    dwApplID;          /* appl. id to receive the message */
   cDWORD    dwLength;          /* length of the following CAPI message */
   CAPIMsg_t capiMsg;           /* CAPI message inclusive length word */
} AvmLliReceiveMessage_t;

/* receive a data-b3-indication from the controller */
/* unfortunately it is not possible to define a fixed structure for this */
/*
typedef struct
{
   cDWORD dwApplID;
   cDWORD dwMsgLength;
   CAPI message inclusive length word
   cDWORD dwDataLength;
   Data-B3 block for the message
} AvmLliReceiveDataB3Ind_t;
*/

/* receive information about a new NCCI */
typedef struct
{
   cDWORD dwApplID;             /* appl. id to receive the new NCCI */
   cDWORD dwNcci;               /* NCCI of the established connection */
   cDWORD dwWindowSize;         /* window size of the established connection */
} AvmLliReceiveNewNcci_t;

/* receive information about a released NCCI or application */
typedef struct
{
   cDWORD dwApplID;             /* appl. id for that the NCCI is released or
                                 * that is released completely
                                 */
   cDWORD dwNcci;               /* NCCI that is released; if 0xFFFFFFFF the
                                 * application itself is released
                                 */
} AvmLliReceiveFreeNcci_t;

/* receive initialization information about a controller */
typedef struct
{
   cDWORD dwLength;
   /* a byte array of controller information follows */
} AvmLliReceiveInit_t;

/* receive information about a completed task */
typedef struct
{
   cDWORD dwApplID;             /* appl. id for that the NCCI is released or
                                 * that is released completely
                                 */
   cDWORD dwLength;             /* length of the following message */
   /* the textual message follows */
} AvmLliReceiveTaskReady_t;

/* receive a debug message */
typedef struct
{
   cDWORD dwLength;             /* length of the following message */
   /* the textual message follows */
} AvmLliReceiveDebugMsg_t;



#include <capi_pack_off.h>





/* === Prototypes for global functions =================================== */





/* === Definition of inline functions ==================================== */





#endif /* __AVMLLI_H */
