/**
 * @file daic_board_params.h
 *
 * Daic-BoardParameters - Board parameter definitions for legacy Diehl ISDN
 * adapters.
 *
 * Copyright: 2005 Thomas Wintergerst. All rights reserved.
 *
 * $Id: daic_board_params.h,v 1.1.2.1 2005/05/27 16:28:26 thomas Exp $
 * $Project:    CAPI for BSD $
 * $Target:     daic - CAPI manager driver for Diehl active ISDN controllers $
 * @date        22.03.2005
 * @author      "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __IX1A_BOARD_PARAMS_H
#define __IX1A_BOARD_PARAMS_H

#include <sys/cdefs.h>          /* __packed */
#include <sys/types.h>          /* u_int32_t, u_int8_t, etc. */





/* === Public declarations =============================================== */





/**
 * Structure for sending the configuration data to a board.
 */
typedef struct
{
   unsigned char ucTei;         ///< The TEI value to use.
   unsigned char ucNt2;         ///< Flag for point-to-point or multipoint op.
   unsigned char ucSkip1;
   unsigned char ucWatchDog;
   unsigned char ucPermanent;   ///< Flag for a permanent or dial connection.
   unsigned char ucXInterface;
   unsigned char ucStableL2;    ///< D-channel layer 2 connection setting.
   unsigned char ucNoOrderCheck;
   unsigned char ucHandsetType;
   unsigned char ucSkip2;
   unsigned char ucLowChannel;  ///< For S2m: Setting for the channel selection
                                ///< for outgoing calls.
   unsigned char ucProtVersion;
   unsigned char ucCrc4;        ///< For S2m: Setting for CRC4 support.
   unsigned char ucLoopback;
   unsigned char aucOad1 [32];  ///< U.S. protocols: First originator address.
   unsigned char aucOsa1 [32];  ///< U.S. protocols: First originator subaddr.
   unsigned char aucSpid1 [32]; ///< U.S. protocols: First service prot. id.
   unsigned char aucOad2 [32];  ///< U.S. protocols: Second originator address.
   unsigned char aucOsa2 [32];  ///< U.S. protocols: Second originator subaddr.
   unsigned char aucSpid2 [32]; ///< U.S. protocols: Second service prot. id.
   unsigned char ucMemBootOpt;  ///< Flag for the board to perform a memory test.
} __packed DaicBoardConfigData_t;





/* === Prototypes of interface functions ================================= */





#endif /* __IX1A_BOARD_PARAMS_H */
