/**
 * @file daic_bootstrap.c
 *
 * Daic-Bootstrap - Definition of the default bootstrap data variable.
 *
 * Copyright: 2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: daic_bootstrap.c,v 1.5.4.1 2005/05/27 16:28:26 thomas Exp $
 * $Project:    CAPI for BSD $
 * $Target:     daic - CAPI manager driver for Diehl active ISDN controllers $
 * @date        23.02.2003
 * @author      "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD$");

/* System includes */
#include <sys/param.h>  /* u_int8_t */

/* Import includes */

#define __DAIC_BOOTSTRAP__

/* Local includes */
#include <c4b/driver/daic/daic_bootstrap.h>





/* === Private definitions =============================================== */





/* === Definitions for public declarations =============================== */





/**
 * The default bootstrap code for the S0 boards.
 *
 * @note The size is specified explicitly to ensure the array is really 1KB
 *       large. With some compiler warning setting this should even lead to an
 *       error if the assignment does not contain enough the bytes.
 */
u_int8_t e_abDaicBootCodeBasic [1024] =
   {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xFA, 0xB8, 0xC0, 0xFF, 0x8E, 0xD8, 0x8E, 0xD0, 0xBC, 0xFE, 0x00, 0xC6, 0x06, 0x01, 0x00, 0x00,
      0xB8, 0x00, 0xFE, 0x8E, 0xC0, 0xC6, 0x06, 0xFF, 0x03, 0xFE, 0x26, 0xC6, 0x06, 0xEB, 0x0F, 0x40,
      0x26, 0x39, 0x06, 0xFE, 0x0E, 0x75, 0x30, 0xB8, 0x44, 0x47, 0x26, 0x39, 0x06, 0xFE, 0x0E, 0x75,
      0x26, 0x26, 0xC7, 0x06, 0xE8, 0x0F, 0x55, 0x75, 0x26, 0xC6, 0x06, 0xE1, 0x0F, 0x93, 0x26, 0xC6,
      0x06, 0x02, 0x0F, 0x80, 0x26, 0xC6, 0x06, 0x0A, 0x0F, 0x80, 0xC6, 0x06, 0x02, 0x00, 0x3C, 0xC6,
      0x06, 0x01, 0x00, 0x02, 0xE9, 0xB5, 0x00, 0xB8, 0xF8, 0x01, 0xBA, 0xA6, 0xFF, 0xEF, 0xB8, 0x39,
      0x00, 0xBA, 0xA4, 0xFF, 0xEF, 0xC6, 0x06, 0x01, 0x00, 0x01, 0xB8, 0xB8, 0xC0, 0xBA, 0xA8, 0xFF,
      0xEF, 0xC6, 0x06, 0x02, 0x00, 0x08, 0x33, 0xDB, 0x8E, 0xC3, 0xB8, 0x44, 0x47, 0x26, 0xA3, 0x00,
      0x00, 0x26, 0x89, 0x1E, 0x00, 0x80, 0x26, 0x39, 0x06, 0x00, 0x00, 0x75, 0x52, 0x50, 0xE4, 0x21,
      0x24, 0xFD, 0x3C, 0x48, 0x58, 0x75, 0x07, 0xC6, 0x06, 0x01, 0x00, 0x03, 0xEB, 0x6E, 0xBB, 0x00,
      0x20, 0x8E, 0xC3, 0x26, 0xA3, 0x00, 0x00, 0x26, 0x39, 0x06, 0x00, 0x00, 0x75, 0x5E, 0xC6, 0x06,
      0x02, 0x00, 0x10, 0xBB, 0x00, 0x40, 0x8E, 0xC3, 0x26, 0xA3, 0x00, 0x00, 0x26, 0x39, 0x06, 0x00,
      0x00, 0x75, 0x49, 0xC6, 0x06, 0x02, 0x00, 0x18, 0xBB, 0x00, 0x60, 0x8E, 0xC3, 0x26, 0xA3, 0x00,
      0x00, 0x26, 0x39, 0x06, 0x00, 0x00, 0x75, 0x34, 0xC6, 0x06, 0x02, 0x00, 0x20, 0xEB, 0x2D, 0xB8,
      0xB8, 0x90, 0xBA, 0xA8, 0xFF, 0xEF, 0xB8, 0x44, 0x47, 0x26, 0xA3, 0x00, 0x00, 0x26, 0x39, 0x06,
      0x00, 0x00, 0x74, 0x18, 0xC6, 0x06, 0x01, 0x00, 0x00, 0xB8, 0xF8, 0x3F, 0xBA, 0xA2, 0xFF, 0xEF,
      0xB8, 0x38, 0x80, 0xBA, 0xA8, 0xFF, 0xEF, 0xC6, 0x06, 0x02, 0x00, 0x10, 0xC7, 0x06, 0x04, 0x00,
      0x00, 0x00, 0xFC, 0x80, 0x3E, 0x00, 0x00, 0x01, 0xC6, 0x06, 0x00, 0x00, 0x03, 0x74, 0x02, 0xEB,
      0x71, 0x1E, 0x33, 0xC9, 0x8A, 0x0E, 0x02, 0x00, 0xB8, 0x00, 0x00, 0x51, 0x50, 0xB9, 0x00, 0x20,
      0x8E, 0xC0, 0x80, 0xCC, 0xC0, 0xBF, 0x00, 0x00, 0xAB, 0xD1, 0xE8, 0x73, 0x03, 0x35, 0x00, 0x90,
      0xE2, 0xF6, 0x58, 0x59, 0x05, 0x00, 0x04, 0xE2, 0xE2, 0x1F, 0x1E, 0x33, 0xC9, 0x8A, 0x0E, 0x02,
      0x00, 0xBB, 0x00, 0x00, 0x51, 0x53, 0xB9, 0x00, 0x20, 0x8E, 0xDB, 0x80, 0xCF, 0xC0, 0xBE, 0x00,
      0x00, 0xAD, 0x3B, 0xD8, 0x75, 0x15, 0xD1, 0xEB, 0x73, 0x04, 0x81, 0xF3, 0x00, 0x90, 0xE2, 0xF1,
      0x5B, 0x59, 0x81, 0xC3, 0x00, 0x04, 0xE2, 0xDC, 0x1F, 0xEB, 0x17, 0x33, 0xC3, 0x8C, 0xDA, 0x0E,
      0x1F, 0xA3, 0x04, 0x00, 0x89, 0x36, 0x06, 0x00, 0x89, 0x16, 0x08, 0x00, 0xC6, 0x06, 0x00, 0x00,
      0x00, 0xF4, 0x33, 0xC9, 0xB1, 0x10, 0x33, 0xC0, 0x33, 0xDB, 0x51, 0x8E, 0xC3, 0xB9, 0x00, 0x20,
      0x33, 0xFF, 0xF3, 0xAB, 0x81, 0xC3, 0x00, 0x04, 0x59, 0xE2, 0xEF, 0xBB, 0x10, 0x00, 0xC6, 0x06,
      0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x3C, 0x02, 0x74, 0x15, 0x3C, 0x01, 0x75, 0xF5, 0xB9, 0x80,
      0x00, 0xBE, 0x00, 0x01, 0x8E, 0xC3, 0x33, 0xFF, 0xF3, 0xA5, 0x83, 0xC3, 0x10, 0xEB, 0xDF, 0xEA,
      0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xBA, 0xA0, 0xFF, 0xB8, 0xF8, 0xFF, 0xEF, 0xEA, 0x00, 0x02, 0xC0, 0xFF, 0x00, 0x00, 0x00, 0x00
   };



/**
 * The default bootstrap code for the S2m board.
 *
 * @note The size is specified explicitly to ensure the array is really 1KB
 *       large. With some compiler warning setting this should even lead to an
 *       error if the assignment does not contain enough the bytes.
 */
u_int8_t e_abDaicBootCodePrimary [1024] =
   {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xFA, 0xB8, 0x00, 0xFC, 0x8E, 0xD8, 0x8E, 0xD0, 0xBC, 0xFE, 0x00, 0xB8, 0x44, 0x47, 0xC7, 0x06,
      0x06, 0x00, 0x44, 0x47, 0xC7, 0x06, 0x08, 0x00, 0x44, 0x47, 0xC6, 0x06, 0x01, 0x00, 0x04, 0xC6,
      0x06, 0x02, 0x00, 0x20, 0xC7, 0x06, 0x04, 0x00, 0x00, 0x00, 0xFC, 0x80, 0x3E, 0x00, 0x00, 0x01,
      0xC6, 0x06, 0x00, 0x00, 0x03, 0x74, 0x02, 0xEB, 0x71, 0x1E, 0x33, 0xC9, 0x8A, 0x0E, 0x02, 0x00,
      0xB8, 0x00, 0x00, 0x51, 0x50, 0xB9, 0x00, 0x20, 0x8E, 0xC0, 0x80, 0xCC, 0xC0, 0xBF, 0x00, 0x00,
      0xAB, 0xD1, 0xE8, 0x73, 0x03, 0x35, 0x00, 0x90, 0xE2, 0xF6, 0x58, 0x59, 0x05, 0x00, 0x04, 0xE2,
      0xE2, 0x1F, 0x1E, 0x33, 0xC9, 0x8A, 0x0E, 0x02, 0x00, 0xBB, 0x00, 0x00, 0x51, 0x53, 0xB9, 0x00,
      0x20, 0x8E, 0xDB, 0x80, 0xCF, 0xC0, 0xBE, 0x00, 0x00, 0xAD, 0x3B, 0xD8, 0x75, 0x15, 0xD1, 0xEB,
      0x73, 0x04, 0x81, 0xF3, 0x00, 0x90, 0xE2, 0xF1, 0x5B, 0x59, 0x81, 0xC3, 0x00, 0x04, 0xE2, 0xDC,
      0x1F, 0xEB, 0x17, 0x33, 0xC3, 0x8C, 0xDA, 0x0E, 0x1F, 0xA3, 0x04, 0x00, 0x89, 0x36, 0x06, 0x00,
      0x89, 0x16, 0x08, 0x00, 0xC6, 0x06, 0x00, 0x00, 0x00, 0xF4, 0x33, 0xC9, 0xB1, 0x10, 0x33, 0xC0,
      0x33, 0xDB, 0x51, 0x8E, 0xC3, 0xB9, 0x00, 0x20, 0x33, 0xFF, 0xF3, 0xAB, 0x81, 0xC3, 0x00, 0x04,
      0x59, 0xE2, 0xEF, 0x0F, 0x20, 0xC0, 0x66, 0x35, 0x00, 0x00, 0x00, 0x60, 0x0F, 0x22, 0xC0, 0x66,
      0xB8, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x22, 0xDC, 0xBB, 0x10, 0x00, 0xC6, 0x06, 0x00, 0x00, 0x00,
      0xA0, 0x00, 0x00, 0x3C, 0x02, 0x74, 0x15, 0x3C, 0x01, 0x75, 0xF5, 0xB9, 0x80, 0x00, 0xBE, 0x00,
      0x01, 0x8E, 0xC3, 0x33, 0xFF, 0xF3, 0xA5, 0x83, 0xC3, 0x10, 0xEB, 0xDF, 0xEA, 0x00, 0x00, 0x10,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xEA, 0x00, 0x02, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
   };





/* === Prototypes for private functions ================================== */





/* === Implementation of public functions ================================ */





/* === Implementation of private functions =============================== */
