/**
 * @file daic_hwdefs.h
 *
 * Daic-HardwareDefinitions - Definitions for the hardware interface of the
 * boards.
 *
 * Copyright: 2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: daic_hwdefs.h,v 1.12.2.1 2005/05/27 16:28:29 thomas Exp $
 * $Project:    CAPI for BSD $
 * $Target:     daic - CAPI manager driver for Diehl active ISDN controllers $
 * @date        10.04.2003
 * @author      "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __DAIC_HWDEFS_H
#define __DAIC_HWDEFS_H





/* === Public declarations =============================================== */





/* --- The hardware definition for Diehl boards --- */

#define DAIC_MEMORY_SIZE_BASIC          0x0800
#define DAIC_MEMORY_SIZE_PRIMARY        0x4000

#define DAIC_SHMEM_SIZE_BASIC           0x0402

/* shared memory offsets while loading primary bootstrap, before and while
 * loading firmware
 */
#define DAIC_SHMEM_OFFSET_CTRL          0x0000
#define DAIC_SHMEM_OFFSET_GET_CARDTYPE  0x0001
#define DAIC_SHMEM_OFFSET_MEMSIZE       0x0002
#define DAIC_SHMEM_OFFSET_EBIT          0x0004 /* 2 bytes */
#define DAIC_SHMEM_OFFSET_ELOC          0x0006 /* 4 bytes */
#define DAIC_SHMEM_OFFSET_IFTYPE        0x001D
#define DAIC_SHMEM_OFFSET_SIGNATURE     0x001E /* 2 bytes */
#define DAIC_SHMEM_OFFSET_FWBUF         0x0100 /* 256 bytes */

/* shared memory offsets and length values for the firmware configuration data
 */
#define DAIC_SHMEM_LEN_BASIC_CONFIG     14
#define DAIC_SHMEM_OFFSET_TEI           0x0008
#define DAIC_SHMEM_OFFSET_NT2           0x0009
#define DAIC_SHMEM_OFFSET_WATCHDOG      0x000B
#define DAIC_SHMEM_OFFSET_PERMANENT     0x000C
#define DAIC_SHMEM_OFFSET_XINTERFACE    0x000D
#define DAIC_SHMEM_OFFSET_STABLE_L2     0x000E
#define DAIC_SHMEM_OFFSET_NOORDERCHECK  0x000F
#define DAIC_SHMEM_OFFSET_HANDSET_TYPE  0x0010
#define DAIC_SHMEM_OFFSET_LOW_CHANNEL   0x0012
#define DAIC_SHMEM_OFFSET_PROT_VERSION  0x0013
#define DAIC_SHMEM_OFFSET_CRC4          0x0014
#define DAIC_SHMEM_OFFSET_LOOPBACK      0x0015
#define DAIC_SHMEM_LEN_OAD              32
#define DAIC_SHMEM_LEN_OSA              32
#define DAIC_SHMEM_LEN_SPID             32
#define DAIC_SHMEM_OFFSET_OAD1          0x0020
#define DAIC_SHMEM_OFFSET_OSA1          0x0040
#define DAIC_SHMEM_OFFSET_SPID1         0x0060
#define DAIC_SHMEM_OFFSET_OAD2          0x0080
#define DAIC_SHMEM_OFFSET_OSA2          0x00A0
#define DAIC_SHMEM_OFFSET_SPID2         0x00C0

/* shared memory offsets for normal operation */
#define DAIC_SHMEM_OFFSET_REQ           0x0000
#define DAIC_SHMEM_OFFSET_REQID         0x0001
#define DAIC_SHMEM_OFFSET_RC            0x0002
#define DAIC_SHMEM_OFFSET_RCID          0x0003
#define DAIC_SHMEM_OFFSET_IND           0x0004
#define DAIC_SHMEM_OFFSET_INDID         0x0005
#define DAIC_SHMEM_OFFSET_IMASK         0x0006
#define DAIC_SHMEM_OFFSET_RNR           0x0007
#define DAIC_SHMEM_OFFSET_XLOCK         0x0008
#define DAIC_SHMEM_OFFSET_INTERRUPT     0x0009
#define DAIC_SHMEM_OFFSET_REQCH         0x000A
#define DAIC_SHMEM_OFFSET_RCCH          0x000B
#define DAIC_SHMEM_OFFSET_INDCH         0x000C
#define DAIC_SHMEM_OFFSET_MIND          0x000D
#define DAIC_SHMEM_OFFSET_MLENGTH       0x000E /* 2 bytes */
#define DAIC_SHMEM_OFFSET_READY_INT     0x0010
#define DAIC_SHMEM_OFFSET_XBUFFER       0x0020 /* 272 bytes */
#define DAIC_SHMEM_OFFSET_RBUFFER       0x0130 /* 272 bytes */
#define DAIC_SHMEM_LEN_RXBUFFER         270    /* buffer length w/o length word */

#define DAIC_SHMEM_OFFSET_NUM_CHANNELS  0x03F6
#define DAIC_SHMEM_OFFSET_SWID          0x03F8 /* 4 bytes */
#define DAIC_SHMEM_OFFSET_SET_CARDTYPE  0x03FC

#define DAIC_SHMEM_OFFSET_INTACK_BASIC          0x03FE
#define DAIC_SHMEM_OFFSET_STOPCPU_BASIC         0x0400
#define DAIC_SHMEM_OFFSET_STARTCPU_BASIC        0x0401

#define DAIC_SHMEM_OFFSET_INTACK_PRIMARY        0x3FFC
#define DAIC_SHMEM_OFFSET_STOPCPU_PRIMARY       0x3FFE
#define DAIC_SHMEM_OFFSET_STARTCPU_PRIMARY      0x3FFF

/* allowed values to write into or read from the control register at
 * DAIC_SHMEM_OFFSET_CTRL
 */
#define DAIC_TEST_READY         0
#define DAIC_TEST_MEMORY        1
#define DAIC_TEST_SKIP          2
#define DAIC_TEST_BUSY          3

/* signature value as a positive start acknowledge from the firmware */
#define DAIC_SIGNATURE_VALUE    0x4447



/* --- Return codes delivered by a board --- */
#define DAIC_RC_UNKNOWN_COMMAND 0x01
#define DAIC_RC_WRONG_COMMAND   0x02
#define DAIC_RC_WRONG_ID        0x03
#define DAIC_RC_WRONG_CH        0x04
#define DAIC_RC_UNKNOWN_IE      0x05
#define DAIC_RC_WRONG_IE        0x06
#define DAIC_RC_OUT_OF_RESOURCES 0x07
#define DAIC_RC_ADAPTER_DEAD    0x08
#define DAIC_RC_N_FLOW_CONTROL  0x10
#define DAIC_RC_ASSIGN_MASK     0xE0
#define DAIC_RC_ASSIGN_OK       0xEF
#define DAIC_RC_OK_FC           0xFC
#define DAIC_RC_READY_INT       0xFD
#define DAIC_RC_TIMER_INT       0xFE
#define DAIC_RC_OK              0xFF



/* --- Global ids to obtain specific ids --- */

#define DAIC_SIG_GLOBAL_ID      0x00
#define DAIC_NL_GLOBAL_ID       0x20
#define DAIC_LL_GLOBAL_ID       0x60
#define DAIC_TASK_GLOBAL_ID     0x80
#define DAIC_TIMER_GLOBAL_ID    0xA0
#define DAIC_TEL_GLOBAL_ID      0xC0
#define DAIC_MGMT_GLOBAL_ID     0xE0

#define DAIC_ERR_ID             0x1F



/* --- Requests and indications for the signalling ids --- */

#define DAIC_SIG_ASSIGN         0x01
#define DAIC_SIG_CALL_REQ       0x01
#define DAIC_SIG_CALL_CON       0x01
#define DAIC_SIG_LISTEN_REQ     0x02
#define DAIC_SIG_CALL_IND       0x02
#define DAIC_SIG_HANGUP         0x03
#define DAIC_SIG_SUSPEND        0x04
#define DAIC_SIG_RESUME         0x05
#define DAIC_SIG_SUSPEND_REJ    0x06
#define DAIC_SIG_USER_DATA      0x08
#define DAIC_SIG_CONGESTION     0x09
#define DAIC_SIG_INDICATE_REQ   0x0A
#define DAIC_SIG_INDICATE_IND   0x0A
#define DAIC_SIG_CALL_RES       0x0B
#define DAIC_SIG_ALERT          0x0C
#define DAIC_SIG_INFO_REQ       0x0D
#define DAIC_SIG_INFO_IND       0x0D
#define DAIC_SIG_REMOVE         0xFF

/* We need the number of requests and indications for state tables in the NCCI
 * state machines. The Remove-Request will be translated to a table index one
 * behind the last defined number (in this case DAIC_SIG_NUM_CMDS).
 */
#define DAIC_SIG_NUM_CMDS       0x0E



/* --- Requests and indications for the network ids --- */

#define DAIC_NL_ASSIGN          0x01
#define DAIC_NL_MDATA           0x01
#define DAIC_NL_CONNECT         0x02
#define DAIC_NL_CONNECT_ACK     0x03
#define DAIC_NL_DISC            0x04
#define DAIC_NL_DISC_ACK        0x05
#define DAIC_NL_RESET           0x06
#define DAIC_NL_RESET_ACK       0x07
#define DAIC_NL_DATA            0x08
#define DAIC_NL_EDATA           0x09
#define DAIC_NL_UDATA           0x0A
#define DAIC_NL_BDATA           0x0B
#define DAIC_NL_REMOVE          0xFF

/* We need the number of requests and indications for state tables in the NCCI
 * state machines. The Remove-Request will be translated to a table index one
 * behind the last defined number (in this case DAIC_NL_NUM_CMDS).
 */
#define DAIC_NL_NUM_CMDS        0x0C

/** @name Additional flags for network layer commands */
/** @{ */

/** Delivery Confirmation bit. */
#define DAIC_NL_CMDBIT_DEL_CONF         0x40

/** More-Data bit. */
#define DAIC_NL_CMDBIT_MORE_DATA        0x20

/** Qualifier bit. */
#define DAIC_NL_CMDBIT_QUALIFIER        0x10

/** Summation of all flags for network layer commands. */
#define DAIC_NL_CMDBIT_MASK             0xF0

/** @} */



/* --- Coding of D-channel message types --- */

/* call establishment messages */
#define DAIC_MT_ALERTING                0x01
#define DAIC_MT_CALL_PROCEEDING         0x02
#define DAIC_MT_CONNECT                 0x07
#define DAIC_MT_CONNECT_ACK             0x0F
#define DAIC_MT_PROGRESS                0x03
#define DAIC_MT_SETUP                   0x05
#define DAIC_MT_SETUP_ACK               0x0D

/* call information phase messages */
#define DAIC_MT_RESUME                  0x26
#define DAIC_MT_RESUME_ACK              0x2E
#define DAIC_MT_RESUME_REJECT           0x22
#define DAIC_MT_SUSPEND                 0x25
#define DAIC_MT_SUSPEND_ACK             0x2D
#define DAIC_MT_SUSPEND_REJECT          0x21
#define DAIC_MT_USER_INFO               0x20

/* call clearing messages */
#define DAIC_MT_DISCONNECT              0x45
#define DAIC_MT_RELEASE                 0x4D
#define DAIC_MT_RELEASE_COMPLETE        0x5A
#define DAIC_MT_RESTART                 0x46
#define DAIC_MT_RESTART_ACK             0x4E

/* miscellaneous messages */
#define DAIC_MT_SEGMENT                 0x60
#define DAIC_MT_CONGESTION_CONTROL      0x79
#define DAIC_MT_INFORMATION             0x7B
#define DAIC_MT_FACILITY                0x62
#define DAIC_MT_NOTIFY                  0x6E
#define DAIC_MT_STATUS                  0x7D
#define DAIC_MT_STATUS_ENQUIRY          0x75



/* --- Coding of information elements --- */

/* Q.931 information elements for codeset 0 */
#define DAIC_IE_BC      0x04 /* Bearer capability */
#define DAIC_IE_CAU     0x08 /* Cause */
#define DAIC_IE_CAD     0x0C /* Connected Address ??? */
#define DAIC_IE_CAI     0x10 /* Call identity */
#define DAIC_IE_CHI     0x18 /* Channel information */
#define DAIC_IE_FAC     0x1C /* Facility */
#define DAIC_IE_PRO     0x1E /* Progress Indicator */
#define DAIC_IE_NFA     0x20 /* Network-specific Facility */
#define DAIC_IE_NOI     0x27 /* Notification Indicator */
#define DAIC_IE_DIS     0x28 /* Display */
#define DAIC_IE_DT      0x29 /* Date/Time */
#define DAIC_IE_KEY     0x2C /* Keypad facility */
#define DAIC_IE_CNO     0x4C /* Connected number */
#define DAIC_IE_CSA     0x4D /* Connected subaddress */
#define DAIC_IE_OAD     0x6C /* Originating address */
#define DAIC_IE_OSA     0x6D /* Originating subaddress */
#define DAIC_IE_CPN     0x70 /* Called party number */
#define DAIC_IE_DSA     0x71 /* Called party subaddress (destination subaddress) */
#define DAIC_IE_RDNG    0x74 /* Redirecting Number */
#define DAIC_IE_RDON    0x76 /* Redirection Number */
#define DAIC_IE_LLC     0x7C /* Low layer compatibility */
#define DAIC_IE_HLC     0x7D /* High layer compatibility */
#define DAIC_IE_UUI     0x7E /* User-user data */
#define DAIC_IE_ESC     0x7F /* Escape for extension */
#define DAIC_IE_SHIFT   0x90 /* Code set shift */
#define DAIC_IE_MORE    0xA0
#define DAIC_IE_SCP     0xA1 /* Sending Complete */
#define DAIC_IE_CL      0xB0 /* Congestion Level */

/* Eicon-specific information elements for codeset 0 (escaped by ESC, 0x7F) */
#define DAIC_IE_MT      0x7A /* Message Type (e.g. in Info-Ind) */
#define DAIC_IE_ECAU    0x08 /* Escaped Cause (don't know what it's for) */

/* information elements for codeset 6 */
#define DAIC_IE_SIN     0x01 /* Service indicator */
#define DAIC_IE_CIF     0x02 /* Charging information */
#define DAIC_IE_DATE    0x03 /* Date information */
#define DAIC_IE_CPS     0x07 /* Called party state */

/* information elements used with network id.s */
#define DAIC_NIE_CAI    0x10 /* Call identity */
#define DAIC_NIE_DLC    0x20 /* Data Link Configuration */
#define DAIC_NIE_NLC    0x21 /* Network Link Configuration */
#define DAIC_NIE_LLC    0x7C /* Low layer compatibility */



/* --- Coding of some important cause values --- */

#define DAIC_CAUSE_CHANNEL_UNACCEPTABLE \
                                0x06 /* channel unacceptable */
#define DAIC_CAUSE_NORMAL       0x10 /* normal call clearing */
#define DAIC_CAUSE_USER_BUSY    0x11 /* user busy */
#define DAIC_CAUSE_NO_USER_RESPONDING \
                                0x12 /* no user responding */
#define DAIC_CAUSE_NO_ANSWER    0x13 /* no answer from user (user alerted) */
#define DAIC_CAUSE_NON_SELECTED_USER_CLEARING \
                                0x1A /* non-selected user clearing */
#define DAIC_CAUSE_DEST_OUT_OF_ORDER \
                                0x1B /* destination out of order */
#define DAIC_CAUSE_FACILITY_REJECTED \
                                0x1D /* facility rejected */
#define DAIC_CAUSE_NORMAL_UNSPEC \
                                0x1F /* normal, unspecified */
#define DAIC_CAUSE_NO_CHANNEL_AVAIL \
                                0x22 /* no channel / circuit available */
#define DAIC_CAUSE_TEMP_FAILURE 0x29 /* temporary failure */
#define DAIC_CAUSE_RESOURCE_UNAVAIL_UNSPEC \
                                0x2F /* resource unavailable, unspecified */
#define DAIC_CAUSE_INCOMPAT_DESTINATION \
                                0x58 /* incompatible destination */





/* === Prototypes of interface functions ================================= */





#endif /* __DAIC_HWDEFS_H */
