/**
 * @file i4bcmgr_capiutil.h
 *
 * I4BCMgr-CapiUtil - utility functions to handle CAPI messages.
 *
 * Copyright: 2000-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: i4bcmgr_capiutil.h,v 1.6.4.1 2005/05/27 16:29:03 thomas Exp $
 * Project  CAPI for BSD
 * Target   i4bcapimgr - The I4B driver for CAPI manager driven controllers
 * @date    01.01.2000
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __I4BCMGR_CAPIUTIL_H
#define __I4BCMGR_CAPIUTIL_H

#include <capi20.h>





/* === public declarations =============================================== */





/* === prototypes of interface functions ================================= */





/* --- extracting data from CAPI messages --- */

/* store the called party number into a character array */
extern const unsigned char *CapiUt_ExtractCalledPartyNumber
   (const unsigned char *pOrgPos,
    char                *pszCalledPartyNumber,
    size_t               nLenCalledPartyNumber);
    
/* store the calling party number into a character array */
extern const unsigned char *CapiUt_ExtractCallingPartyNumber
   (const unsigned char *pOrgPos,
    char                *pszCallingPartyNumber,
    size_t               nLenCallingPartyNumber,
    int                 *piScreeningInd,
    int                 *piPresentationInd);
    
    
    
/* --- enter some CAPI structures into CAPI messages --- */

/* enter an empty CAPI structure at specified position */
extern unsigned char *CapiUt_EnterEmptyStruct
   (unsigned char *pOrgPos);
   
/* enter a string into a CAPI structure at specified position */
extern unsigned char *CapiUt_EnterString
   (unsigned char *pOrgPos,
    const char    *pszString);
    
/* enter the called party number at specified position */
extern unsigned char *CapiUt_EnterCalledPartyNumber
   (unsigned char *pOrgPos,
    const char    *pszNumber);
    
/* enter the calling party number at specified position */
extern unsigned char *CapiUt_EnterCallingPartyNumber
   (unsigned char *pOrgPos,
    const char    *pszNumber);
    




#endif /* __I4BCMGR_CAPIUTIL_H */
