/**
 * @file i4bcmgr_plcism.h
 *
 * I4BCMgr-PlciSM - Interface of the PLCI state machine.
 *
 * Copyright: 2000-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: i4bcmgr_plcism.h,v 1.7.4.1 2005/05/27 16:29:05 thomas Exp $
 * Project  CAPI for BSD
 * Target   i4bcapimgr - The I4B driver for CAPI manager driven controllers
 * @date    01.01.2000
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __I4BCMGR_PLCISM_H
#define __I4BCMGR_PLCISM_H

#include <i4b/i4bcapimgr/i4bcmgr_global.h>





/* === public declarations =============================================== */





/* === prototypes of interface functions ================================= */





/* --- entries for the PLCI state machine from the NCCI layer --- */

/* start a new outgoing connection */
extern void I4bCmgr_PlciConnectReq
   (I4bCapiConnectionData_t *pConnData);

/* acknowledge a new incoming connection */
extern void I4bCmgr_PlciConnectResp
   (I4bCapiConnectionData_t  *pConnData,
    const I4bCapiEventData_t *pEventData);

/* terminate a connection */
extern void I4bCmgr_PlciDisconnectReq
   (I4bCapiConnectionData_t  *pConnData,
    const I4bCapiEventData_t *pEventData);

/* do not let a new incoming connection expire */
extern void I4bCmgr_PlciAlertReq
   (I4bCapiConnectionData_t *pConnData);

/* send a B3-level CAPI message */
extern unsigned I4bCmgr_PlciPutB3Msg
   (I4bCapiConnectionData_t *pConnData,
    struct mbuf             *pmbMsg);

/* handle timeout for the PLCI layer */
extern void I4bCmgr_PlciTimeout
   (I4bCapiConnectionData_t *pConnData);



/* --- entries for the PLCI state machine from the CAPI layer --- */

/* handle an incoming CAPI message */
extern void I4bCmgr_PlciReceiveCapiMessage
   (CAPIMsg_t *pCapiMsg);





/* === definition of inline functions ==================================== */





#endif /* __I4BCMGR_PLCISM_H */
