/**
 * @file capi_echoc.h
 *
 * CapiEchoCancel - Definitions for the Echo Cancellation feature in addition
 * to the CAPI20-header.
 *
 * Copyright: 2002-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: capi_echoc.h,v 1.8.2.1 2005/05/27 16:29:07 thomas Exp $
 * Project  CAPI for BSD
 * @date    05.06.2002
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __CAPI_ECHOC_H
#define __CAPI_ECHOC_H

#ifndef __CAPIDEF_H
#  include <capidef.h>
#endif

#include <capi_pack_on.h>





/* === public declarations =============================================== */





/* --- functions for echo cancellation support --- */

#define C_ECHOCANCEL_FUNC_GET_SUPPORTED_SERVICES        0x0000
#define C_ECHOCANCEL_FUNC_ENABLE_ECHO_CANCELLER         0x0001
#define C_ECHOCANCEL_FUNC_BYPASS_INDICATION             0x0001
#define C_ECHOCANCEL_FUNC_DISABLE_ECHO_CANCELLER        0x0002



/* --- supported options for echo cancellation --- */

#define C_ECHOCANCEL_SUPP_OPTION_NON_LINEAR_PROCESSING  0x0001
#define C_ECHOCANCEL_SUPP_OPTION_BYPASS_CONTINUOUS_AND_REVERSED 0x0002
#define C_ECHOCANCEL_SUPP_OPTION_BYPASS_REVERSED_ONLY   0x0004
#define C_ECHOCANCEL_SUPP_OPTION_ADAPTIVE_PREDELAY      0x0008



/* --- echo cancellation options to enable --- */

#define C_ECHOCANCEL_ENABLE_OPTION_NON_LINEAR_PROCESSING        0x0001
#define C_ECHOCANCEL_ENABLE_OPTION_IGNORE_DISABLE_TONE          0x0000
#define C_ECHOCANCEL_ENABLE_OPTION_BYPASS_REVERSED_ONLY         0x0004
#define C_ECHOCANCEL_ENABLE_OPTION_BYPASS_CONTINUOUS_AND_REVERSED 0x0006
#define C_ECHOCANCEL_ENABLE_OPTION_ADAPTIVE_PREDELAY            0x0008



/* --- echo canceller bypass event identifiers --- */

#define C_ECHOCANCEL_BYPASS_EVENT_CONTINUOUS_TONE       1
#define C_ECHOCANCEL_BYPASS_EVENT_PHASE_REVERSED_TONE   2
#define C_ECHOCANCEL_BYPASS_EVENT_RELEASED              3



/* --- facility message parameter structures --- */

/* structure of an echo canceller request */
typedef struct CAPIFacilityEchoCancelReq
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wFunction;                /* function of C_ECHOCANCEL_FUNC_* */
/* CAPIStruct EchoCancelReqParameter;*/ /* structures of type
                                         * CAPIEchoCancelParam*
                                         */
} CAPIFacilityEchoCancelReq_t;

/* structure of an echo canceller confirmation */
typedef struct CAPIFacilityEchoCancelConf
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wFunction;                /* function of C_ECHOCANCEL_FUNC_* */
/* CAPIStruct EchoCancelConfParameter;*//* structures of type
                                         * CAPIEchoCancelParam*
                                         */
} CAPIFacilityEchoCancelConf_t;

/* structure of an echo canceller indication */
typedef struct CAPIFacilityEchoCancelInd
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wFunction;                /* function of C_ECHOCANCEL_FUNC_* */
/* CAPIStruct EchoCancelIndParameter;*/ /* structures of type
                                         * CAPIEchoCancelParam*
                                         */
} CAPIFacilityEchoCancelInd_t;

/* no facility parameter for echo canceller response, empty struct */



/* --- echo canceller parameter structures --- */

/* no parameters for EchoCancel-GetSupportedServices-Request, empty struct */

/* structure of the parameter for EchoCancel-Enable-Request */
typedef struct CAPIEchoCancelParamEnableReq
{
   cBYTE bLength;                       /* length of structure */
   cWORD wOptions;                      /* enabling options; bitmask of
                                         * C_ECHOCANCEL_ENABLE_OPTION_*
                                         */
   cWORD wTailLength;                   /* length of the adaptive echo
                                         * cancellation filter in ms; if 0,
                                         * CAPI implementation determines
                                         * appropriate value
                                         */
   cWORD wPreDelayLength;               /* length of the pre-delay in ms that
                                         * can be used to offset the echo
                                         * cancellation filter to tightly
                                         * cover the echo components; applies
                                         * only if options bit 3 (adaptive
                                         * pre-delay) is not set
                                         */
} CAPIEchoCancelParamEnableReq_t;

/* no parameters for EchoCancel-Disable-Request, empty struct */

/* structure of the parameter for EchoCancel-GetSupportedServices-Confirm */
typedef struct CAPIEchoCancelParamGetSupportedServicesConf
{
   cBYTE bLength;                       /* length of the structure */
   cWORD wInfo;                         /* result of the corresp. request */
   cWORD wSuppOptions;                  /* supported options; bitmask of
                                         * C_ECHOCANCEL_SUPP_OPTION_*
                                         */
   cWORD wSuppTailLength;               /* maximum supported length of the
                                         * adaptive echo cancellation filter
                                         * in ms; if 0 only the default is
                                         * supported for parameter tail length
                                         */
   cWORD wSuppPreDelay;                 /* maximum supported length of the
                                         * pre-delay in ms
                                         */
} CAPIEchoCancelParamGetSupportedServicesConf_t;

/* structure of the parameter for EchoCancel-Enable-Confirm */
typedef struct CAPIEchoCancelParamEnableConf
{
   cBYTE bLength;                       /* length of the structure */
   cWORD wInfo;                         /* result of the corresp. request */
} CAPIEchoCancelParamEnableConf_t;

/* structure of the parameter for EchoCancel-Disable-Confirm */
typedef struct CAPIEchoCancelParamDisableConf
{
   cBYTE bLength;                       /* length of the structure */
   cWORD wInfo;                         /* result of the corresp. request */
} CAPIEchoCancelParamDisableConf_t;

/* structure of the parameter for EchoCancel-Bypass-Indication */
typedef struct CAPIEchoCancelParamBypassInd
{
   cBYTE bLength;                       /* length of the structure */
   cWORD wBypassEvent;                  /* the bypass event signalled; bitmask
                                         * of C_ECHOCANCEL_BYPASS_EVENT_*
                                         */
} CAPIEchoCancelParamBypassInd_t;



#include <capi_pack_off.h>





/* === prototypes of interface functions ================================= */





#endif /* __CAPI_ECHOC_H */
