/**
 * @file capi_li.h
 *
 * CapiLineInterconnect - Definitions for the Line Interconnect facility in
 * addition to the CAPI20-header.
 *
 * Copyright: 2002-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: capi_li.h,v 1.7.2.1 2005/05/27 16:29:07 thomas Exp $
 * $Project:    CAPI $
 * $Target:     capi-header $
 * @date    03.08.2002
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __CAPI_LI_H
#define __CAPI_LI_H

#ifndef __CAPIDEF_H
#  include <capidef.h>
#endif

#include <capi_pack_on.h>





/* === public declarations =============================================== */





/* --- functions for line interconnect --- */

#define C_LI_FUNC_GET_SUPPORTED_SERVICES        0x0000
#define C_LI_FUNC_CONNECT                       0x0001
#define C_LI_FUNC_DISCONNECT                    0x0002



/* --- definitions for the line interconnect services supported --- */

#define C_LI_SUPP_SVC_CROSS_CONTROLLER          0x00000001
#define C_LI_SUPP_SVC_ASYMMETRIC_CONNECTIONS    0x00000002
#define C_LI_SUPP_SVC_MONITORING                0x00000004
#define C_LI_SUPP_SVC_MIXING                    0x00000008
#define C_LI_SUPP_SVC_REMOTE_MONITORING         0x00000010
#define C_LI_SUPP_SVC_REMOTE_MIXING             0x00000020
#define C_LI_SUPP_SVC_LINE_DATA_LOOP            0x00000040
#define C_LI_SUPP_SVC_APP_DATA_LOOP             0x00000080
#define C_LI_SUPP_SVC_CONFERENCE_DATA_LOOP      0x00000100



/* --- definitions for controlling the data path --- */

#define C_LI_DATA_PATH_MONITOR_MAIN             0x00000004
#define C_LI_DATA_PATH_MIX_MAIN                 0x00000008
#define C_LI_DATA_PATH_MONITOR_OTHER            0x00000010
#define C_LI_DATA_PATH_MIX_OTHER                0x00000020
#define C_LI_DATA_PATH_LOOP_LINE_DATA           0x00000040
#define C_LI_DATA_PATH_LOOP_APP_DATA            0x00000080
#define C_LI_DATA_PATH_LOOP_CONFERENCE_DATA     0x00000100



/* --- facility message parameter structures --- */

/** Structure of a line interconnect facility request parameter. */
typedef struct CAPIFacilityLIReq
{
   cWORD      wFunction;        /**< Function of C_LI_FUNC_*. */
/* CAPIStruct LIReqParameter; */
                                /* Structure of type CAPILIParam*. */
} CAPIFacilityLIReq_t;

/** Structure of a line interconnect facility confirmation parameter. */
typedef struct CAPIFacilityLIConf
{
   cWORD      wFunction;        /**< LI Function of C_LI_FUNC_*. */
/* CAPIStruct LIConfParameter; */
                                /* Structure of type CAPILIParam*. */
} CAPIFacilityLIConf_t;

/** Structure of a line interconnect facility indication parameter. */
typedef struct CAPIFacilityLIInd
{
   cWORD      wFunction;        /**< LI Function of C_LI_FUNC_*. */
/* CAPIStruct LIIndParameter; */
                                /* Structure of type CAPILIParam*. */
} CAPIFacilityLIInd_t;

/* no facility parameter for line interconnect response, empty struct */



/* --- line interconnect parameter structures --- */

/* No LI-parameters for LI-GetSupportedServices-Request, empty struct. */

/** Structure of the LI-parameter for LI-Connect-Request. */
typedef struct CAPILIParamConnectReq
{
   cDWORD     dwDataPath;       /**<
                                 * Specification of the data flow for the
                                 * calling applications PLCI. Bitmask of
                                 * C_LI_DATA_PATH_*.
                                 */
/* CAPILIConnReqParticipant LIConnReqParticipantsSeq []; */
                                /* Sequence of participants to be connected
                                 * to the conference.
                                 */
} CAPILIParamConnectReq_t;

/* Structure of the LI-parameter for LI-Disconnect-Request. */
/*typedef struct CAPILIParamDisconnectReq */
/*{                                       */
/* CAPILIDiscReqParticipant LIDiscReqParticipantsSeq []; */
                                /* Sequence of participants to be disconnected
                                 * from the conference.
                                 */
/*} CAPILIParamDisconnectReq_t;           */

/** Structure of the LI-parameter for LI-GetSupportedServices-Confirm. */
typedef struct CAPILIParamGetSupportedServicesConf
{
   cWORD  wInfo;                /**< Result of the corresponding request. */
   cDWORD dwSupportedServices;  /**<
                                 * Supported services. Bitmask of
                                 * C_LI_SUPP_SVC_*.
                                 */
   cDWORD dwSupportedInterconnectsOfCurrentController;
                                /**<
                                 * Maximum number of parallel interconnects
                                 * between any two PLCIs which are supported
                                 * by the specified controller.
                                 */
   cDWORD dwSupportedParticipantsOfCurrentController;
                                /**<
                                 * Maximum number of participants which can be
                                 * connected to one main PLCI by the specified
                                 * controller not including the main part.
                                 */
   cDWORD dwSupportedInterconnectsOfAllControllers;
                                /**<
                                 * Maximum number of parallel interconnects
                                 * between any two PLCIs which are supported
                                 * accumulated for all available controllers.
                                 */
   cDWORD dwSupportedParticipantsOfAllControllers;
                                /**<
                                 * Maximum number of participants which can be
                                 * connected to one main PLCI accumulated for
                                 * all available controllers not including the
                                 * main part.
                                 */
} CAPILIParamGetSupportedServicesConf_t;

/** Structure of the LI-parameter for LI-Connect/Disconnect-Confirm. */
typedef struct CAPILIParamConf
{
   cWORD wMainInfo;             /**<
                                 * Result of the correspind request according
                                 * to the main PLCI.
                                 */
/* CAPILIConfParticipant LIConfParticipantsSeq []; */
                                /* Sequence of participant results. */
} CAPILIParamConf_t;

/** Structure of the LI-parameter for LI-Connect-Active-Indication. */
typedef struct CAPILIParamConnActInd
{
   cDWORD dwPartPlci;           /**<
                                 * PLCI of participant interconnected to PLCI
                                 * in main part of the CAPI message.
                                 */
} CAPILIParamConnActInd_t;

/** Structure of the LI-parameter for LI-Disconnect-Indication. */
typedef struct CAPILIParamDisconnectInd
{
   cDWORD dwPartPlci;           /**<
                                 * PLCI of participant disconnected from PLCI
                                 * in main part of the CAPI message.
                                 */
   cWORD  wReason;              /**<
                                 * The reason for the disconnect as a CAPI
                                 * result value.
                                 */
} CAPILIParamDisconnectInd_t;



/* --- some helper definitions --- */

/** Type for a participant of a LI-Connect-Request. */
typedef struct CAPILIConnReqParticipant
{
   cDWORD dwPartPlci;           /**<
                                 * PLCI of the connection to the participant.
                                 */
   cDWORD dwPartDataPath;       /**<
                                 * Specification of the data flow for the
                                 * participants PLCI. Bitmask of
                                 * C_LI_DATA_PATH_*.
                                 */
} CAPILIConnReqParticipant_t;

/** Type for a participant of a LI-Disconnect-Request. */
typedef struct CAPILIDiscReqParticipant
{
   cDWORD dwPartPlci;           /**<
                                 * PLCI of the connection to the participant.
                                 */
} CAPILIDiscReqParticipant_t;

/** Type for a participant of a LI-Connect/Disconnect-Confirmation. */
typedef struct CAPILIConfParticipant
{
   cDWORD dwPartPlci;           /**<
                                 * PLCI of the connection to the participant.
                                 */
   cWORD  wPartInfo;            /**<
                                 * Result of the corresp. request according to
                                 * the participant.
                                 */
} CAPILIConfParticipant_t;



#include <capi_pack_off.h>





/* === prototypes of interface functions ================================= */





#endif /* __CAPI_LI_H */
