/**
 * @file pack_off.h
 *
 * CAPI-Pack-Off - Set the packing of structures in the CAPI message context to
 * platform default.
 *
 * Copyright:   2002-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: capi_pack_off.h,v 1.11.2.1 2005/05/27 16:29:07 thomas Exp $
 * $Project:    CAPI for BSD $
 * $Target:     CAPI headers $
 * @date        03.08.2002
 * @author      "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @section description Description
 *
 * By including this header file the setting for the alignment of structure
 * members will be reset to the compiler and/or platform specific default.
 * It may only be included after <capi_pack_off.h>. Else there will be
 * (sometimes misunderstanding) errors.
 *
 * According to the current platform and the compiler package used the correct
 * commands must be used:
 *
 * @li Microsoft Visual C++ v6.0: Supports "#pragma pack(x)" as well as
 *        "#pragma pack(push|pop)". Because of the the usage in pairs of
 *        <capi_pack_on.h> and <capi_pack_off.h> the push/pop method is chosen.
 *
 * @li Borland: Supports at least since BC v4.5 "#pragma option -a-". If
 *        "#pragma pack(x)" is also supported should be checked if needed.
 *
 * @li Watcom: Supports "#pragma pack(x)".
 *
 * @li GNU-C (at least since v2.95): Supports "#pragma pack(x)" and special
 *        attributes within the structure declarations ("__attribute((pack))").
 *        The later has the disadvantage, that the corresponding structure
 *        cannot be documented by doxygen any more, because the attribute will
 *        falsely be recognized as the structure name. So for GNU-C "#pragma
 *        pack(x)" will be used, too.
 *
 * </p>
 */

#if defined(__BORLANDC__)

#pragma nopackwarning
#pragma option -a.

#elif (defined(__WATCOMC__) || defined(_MSC_VER) || defined(__C89_SINIX_Z__) || defined (__C89_SINIX_N__))

#if (defined(_MSC_VER) && defined(WIN32))

#pragma pack(pop)

#else

#pragma pack()

#endif

#elif defined(__GNUC__)

/* GNU-C at least since v2.95 knows of the pack pragmas */
#pragma pack()

#elif defined(TARGET_AIX)

#pragma options align=reset

#elif defined(TARGET_DEC)

#pragma pack(0)

#elif defined(TARGET_HPUX)

#pragma HP_ALIGN POP

#else
#error Unknown compiler, check "capi_pack_on.h" and "capi_pack_off.h"
#endif
