/**
 * @file capi_result.h
 *
 * CapiResult - Result, info and reason values for CAPI functions and messages
 * in addition to the CAPI20-header.
 *
 * Copyright: 2002-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: capi_result.h,v 1.7.2.1 2005/05/27 16:29:07 thomas Exp $
 * Project  CAPI for BSD
 * @date    03.08.2002
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __CAPI_RESULT_H
#define __CAPI_RESULT_H





/* === public declarations =============================================== */





/* --- info and result values --- */

/* value for "no error" */
#define CAPI_OK                         0x0000

/* class 0x00xx - CAPI information values */
#define CIV_NCPI_IGNORED                0x0001
#define CIV_FLAGS_IGNORED               0x0002
#define CIV_ALERT_ALREADY_SENT          0x0003

/* class 0x10xx - CAPI register error */
#define CRE_TOO_MANY_APPLICATIONS       0x1001
#define CRE_INVALID_BLOCK_SIZE          0x1002
#define CRE_INVALID_BUFFER_SIZE         0x1003
#define CRE_INVALID_MSG_BUFFER          0x1004
#define CRE_INVALID_CONNECT_NUM         0x1005
#define CRE_RESERVED_1006               0x1006
#define CRE_BUSY                        0x1007
#define CRE_OS_RESOURCE_ERROR           0x1008
#define CRE_CAPI_NOT_INSTALLED          0x1009
#define CRE_NO_EXTERNAL_EQUIPMENT       0x100A
#define CRE_NO_INTERNAL_EQUIPMENT       0x100B

/* class 0x11xx - CAPI message exchange error */
#define CME_INVALID_APPLICATION_ID      0x1101
#define CME_ILLEGAL_COMMAND             0x1102
#define CME_PUT_QUEUE_FULL              0x1103
#define CME_GET_QUEUE_EMPTY             0x1104
#define CME_GET_QUEUE_OVERFLOW          0x1105
#define CME_UNKNOWN_NOTIFICATION_PARAM  0x1106
#define CME_BUSY                        0x1107
#define CME_OS_RESOURCE_ERROR           0x1108
#define CME_CAPI_NOT_INSTALLED          0x1109
#define CME_NO_EXTERNAL_EQUIPMENT       0x110A
#define CME_NO_INTERNAL_EQUIPMENT       0x110B

/* class 0x20xx - CAPI coding error */
#define CCE_MSG_NOT_ALLOWED_YET                 0x2001 /* wrong expression in identifier */
#define CCE_MSG_NOT_ALLOWED_NOW                 0x2001
#define CCE_ILLEGAL_IDENTIFIER                  0x2002
#define CCE_NO_PLCI_AVAILABLE                   0x2003
#define CCE_NO_NCCI_AVAILABLE                   0x2004
#define CCE_NO_LISTEN_AVAILABLE                 0x2005
#define CCE_NO_FAX_RESOURCE_AVAILABLE           0x2006
#define CCE_ILLEGAL_MSG_PARAMETER               0x2007
#define CCE_NO_INTERCONNECT_RESOURCES_AVAILABLE 0x2008

/* class 0x30xx - CAPI service request error */
#define CSE_B1_PROTOCOL_NOT_SUPPORTED   0x3001
#define CSE_B2_PROTOCOL_NOT_SUPPORTED   0x3002
#define CSE_B3_PROTOCOL_NOT_SUPPORTED   0x3003
#define CSE_INVALID_B1_PARAMETER        0x3004
#define CSE_INVALID_B2_PARAMETER        0x3005
#define CSE_INVALID_B3_PARAMETER        0x3006
#define CSE_INVALID_B_PROT_COMBINATION  0x3007
#define CSE_NCPI_NOT_SUPPORTED          0x3008
#define CSE_UNKNOWN_CIP_VALUE           0x3009
#define CSE_FLAGS_NOT_SUPPORTED         0x300A
#define CSE_FACILITY_NOT_SUPPORTED      0x300B
#define CSE_DATA_LENGTH_NOT_SUPPORTED   0x300C
#define CSE_RESET_B3_NOT_SUPPORTED      0x300D
#define CSE_SUPPL_SERVICE_NOT_SUPPORTED 0x300E
#define CSE_UNSUPPORTED_INTEROPERABILITY 0x300F
#define CSE_SUPPL_NOT_ALLOWED_YET       0x3010
#define CSE_FACILITY_FUNC_NOT_SUPPORTED 0x3011

/* disconnect reason */
#define CDISC_NO_CAUSE                  0x0000
#define CDISC_PROTOCOL_LAYER_1          0x3301
#define CDISC_PROTOCOL_LAYER_2          0x3302
#define CDISC_PROTOCOL_LAYER_3          0x3303
#define CDISC_CALL_TO_OTHER_APPLICATION 0x3304
#define CDISC_SUPPL_REJECT_BY_SUPERVISION 0x3305

#define CDISC_NETWORK_CAUSE_MASK        0x3400
/* for network disconnect causes see ETS 300 102 / Q.850 */
/* Todo: Must add definitions for these */

#define CDISC_SUPPL_SVC_MASK            0x3600
/* for error information concerning requested supplementary services see ETS
 * 300 196-1 [D.2]
 */
/* Todo: Must add definitions for these */

#define CDISC_SUPPL_SVC_CXT_MASK        0x3700
/* for error information regarding the context of a supplementary service
 * request see ETS 300 196-1 [D.1] "Invoke Problem"
 */
/* Todo: Must add definitions for these */

/* disconnect B3 reason */
#define CDISC_B3_NO_CAUSE               0x0000
#define CDISC_B3_PROTOCOL_LAYER_1       0x3301
#define CDISC_B3_PROTOCOL_LAYER_2       0x3302
#define CDISC_B3_PROTOCOL_LAYER_3       0x3303

/* T.30 specific reasons */
#define CDISC_B3_NO_FAX_G3_REMOTE       0x3311
#define CDISC_B3_TRAINING_ERROR         0x3312
#define CDISC_B3_MODE_SELECT_ERROR      0x3313
#define CDISC_B3_REMOTE_ABORT           0x3314
#define CDISC_B3_REMOTE_PROCEDURE_ERROR 0x3315
#define CDISC_B3_TX_DATA_UNDERRUN       0x3316
#define CDISC_B3_RX_DATA_OVERFLOW       0x3317
#define CDISC_B3_LOCAL_ABORT            0x3318
#define CDISC_B3_ILLEGAL_PARAM_CODING   0x3319

/* modem specific causes */
#define CDISC_B3_NORMAL                 0x3500
#define CDISC_B3_CARRIER_LOST           0x3501
#define CDISC_B3_NEGOTIATION_ERROR      0x3502
#define CDISC_B3_NO_ANSWER              0x3503
#define CDISC_B3_ONLY_SYNCH_MODE        0x3504
#define CDISC_B3_FRAMING_ERROR          0x3505
#define CDISC_B3_PROTOCOL_NEGOTIATION   0x3506
#define CDISC_B3_REMOTE_PROTOCOL_ERROR  0x3507
#define CDISC_B3_SYNCH_MISSING          0x3508
#define CDISC_B3_REMOTE_DISCONNECT      0x3509
#define CDISC_B3_MODEM_NO_ANSWER        0x350A
#define CDISC_B3_PROTOCOL_ERROR         0x350B
#define CDISC_B3_COMPRESSION_ERROR      0x350C
#define CDISC_B3_NO_CONNECT             0x350D
#define CDISC_B3_NO_FALLBACK_ALLOWED    0x350E
#define CDISC_B3_NO_MODEM_REMOTE        0x350F
#define CDISC_B3_HANDSHAKE_ERROR        0x3510

/* reason values for Line Interconnect */
#define CLIR_PLCI_HAS_NO_B_CHANNEL             0x3800
#define CLIR_LINES_NOT_COMPATIBLE              0x3801
#define CLIR_PLCI_NOT_IN_INTERCONNECTION       0x3802





/* === prototypes of interface functions ================================= */





#endif /* __CAPI_RESULT_H */
