/**
 * @file capi_supplsvc.h
 *
 * CapiSupplementaryServices - Definitions for the Supplementary Services in
 * addition to the CAPI20-header.
 *
 * Copyright: 2002-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: capi_supplsvc.h,v 1.7.2.1 2005/05/27 16:29:07 thomas Exp $
 * Project  CAPI for BSD
 * @date    03.08.2002
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __CAPI_SUPPLSVC_H
#define __CAPI_SUPPLSVC_H

#ifndef __CAPIDEF_H
#  include <capidef.h>
#endif

#include <capi_pack_on.h>





/* === public declarations =============================================== */





/* --- definitions for the facility supplementary services --- */

/* functions for the supplementary services */
#define C_SUPPL_FUNC_GET_SUPPORTED_SERVICES     0x0000
#define C_SUPPL_FUNC_LISTEN                     0x0001
#define C_SUPPL_FUNC_HOLD                       0x0002
#define C_SUPPL_FUNC_RETRIEVE                   0x0003
#define C_SUPPL_FUNC_SUSPEND                    0x0004
#define C_SUPPL_FUNC_RESUME                     0x0005
#define C_SUPPL_FUNC_ECT                        0x0006
#define C_SUPPL_FUNC_3PTY_BEGIN                 0x0007
#define C_SUPPL_FUNC_3PTY_END                   0x0008
#define C_SUPPL_FUNC_CF_ACTIVATE                0x0009
#define C_SUPPL_FUNC_CF_DEACTIVATE              0x000A
#define C_SUPPL_FUNC_CF_INTERROGATE_PARAMETERS  0x000B
#define C_SUPPL_FUNC_CF_INTERROGATE_NUMBERS     0x000C
#define C_SUPPL_FUNC_CD                         0x000D
#define C_SUPPL_FUNC_MCID                       0x000E
#define C_SUPPL_FUNC_CCBS_REQUEST               0x000F
#define C_SUPPL_FUNC_CCBS_DEACTIVATE            0x0010
#define C_SUPPL_FUNC_CCBS_INTERROGATE           0x0011
#define C_SUPPL_FUNC_CCBS_CALL                  0x0012
#define C_SUPPL_FUNC_MWI_ACTIVATE               0x0013
#define C_SUPPL_FUNC_MWI_DEACTIVATE             0x0014
#define C_SUPPL_FUNC_CCNR_REQUEST               0x0015
#define C_SUPPL_FUNC_CCNR_INTERROGATE           0x0016
#define C_SUPPL_FUNC_CONF_BEGIN                 0x0017
#define C_SUPPL_FUNC_CONF_ADD                   0x0018
#define C_SUPPL_FUNC_CONF_SPLIT                 0x0019
#define C_SUPPL_FUNC_CONF_DROP                  0x001A
#define C_SUPPL_FUNC_CONF_ISOLATE               0x001B
#define C_SUPPL_FUNC_CONF_REATTACH              0x001C

/* notifications for the supplementary services */
#define C_SUPPL_NOTIFIC_HOLD                    0x8000
#define C_SUPPL_NOTIFIC_RETRIEVE                0x8001
#define C_SUPPL_NOTIFIC_SUSPEND                 0x8002
#define C_SUPPL_NOTIFIC_RESUME                  0x8003
#define C_SUPPL_NOTIFIC_CALL_IS_DIVERTING       0x8004
#define C_SUPPL_NOTIFIC_DIVERSION_ACTIVATED     0x8005
#define C_SUPPL_NOTIFIC_CF_ACTIVATE             0x8006
#define C_SUPPL_NOTIFIC_CF_DEACTIVATE           0x8007
#define C_SUPPL_NOTIFIC_DIVERSION_INFO          0x8008
#define C_SUPPL_NOTIFIC_CALL_TRANSFER_ALERTED   0x8009
#define C_SUPPL_NOTIFIC_CALL_TRANSFER_ACTIVE    0x800A
#define C_SUPPL_NOTIFIC_CONFERENCE_ESTABLISHED  0x800B
#define C_SUPPL_NOTIFIC_CONFERENCE_DISCONNECT   0x800C
#define C_SUPPL_NOTIFIC_CCBS_ERASE_CALL_LID     0x800D
#define C_SUPPL_NOTIFIC_CCBS_STATUS             0x800E
#define C_SUPPL_NOTIFIC_CCBS_REMOTE_USER_FREE   0x800F
#define C_SUPPL_NOTIFIC_CCBS_B_FREE             0x8010
#define C_SUPPL_NOTIFIC_CCBS_ERASE              0x8011
#define C_SUPPL_NOTIFIC_CCBS_STOP_ALERTING      0x8012
#define C_SUPPL_NOTIFIC_CCBS_INFO_RETAIN        0x8013
#define C_SUPPL_NOTIFIC_MWI_INDICATION          0x8014
#define C_SUPPL_NOTIFIC_CCNR_INFO_RETAIN        0x8015
#define C_SUPPL_NOTIFIC_CONF_PARTY_DISC         0x8016
#define C_SUPPL_NOTIFIC_CONF_NOTIFICATIONS      0x8017

/* structure of a supplementary service request */
typedef struct CAPIFacilitySupplReq
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wFunction;                /* function of SUPPL_FUNC_* */
/* CAPIStruct SupplParameter;        */ /* structures of type CAPISupplParam*
                                         */
} CAPIFacilitySupplReq_t;

/* structure of a supplementary services confirmation */
typedef struct CAPIFacilitySupplConf
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wFunction;                /* function of SUPPL_FUNC_* */
/* CAPIStruct SupplParameter;        */ /* structures of type CAPISupplParam*
                                         */
} CAPIFacilitySupplConf_t;

/* structure of a supplementary services indication */
typedef struct CAPIFacilitySupplInd
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wFunction;                /* function of SUPPL_FUNC_* or
                                         * notification of SUPPL_NOTIFIC_*
                                         */
/* CAPIStruct SupplParameter;        */ /* structures of type CAPISupplParam*
                                         */
} CAPIFacilitySupplInd_t;

/* structure of a supplementary services response */
typedef struct CAPIFacilitySupplResp
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wFunction;                /* function of SUPPL_FUNC_* or
                                         * notification of SUPPL_NOTIFIC_*
                                         */
/* CAPIStruct SupplParameter;        */ /* structures of type CAPISupplParam*
                                         */
} CAPIFacilitySupplResp_t;

/* definition of the bit mask for the supported sub-services */
#define C_SUPPL_SERVICE_HOLD_RETRIEVE   0x00000001UL
#define C_SUPPL_SERVICE_TERMINAL_PORTAB 0x00000002UL
#define C_SUPPL_SERVICE_ECT             0x00000004UL
#define C_SUPPL_SERVICE_3PTY            0x00000008UL
#define C_SUPPL_SERVICE_CF              0x00000010UL
#define C_SUPPL_SERVICE_CD              0x00000020UL
#define C_SUPPL_SERVICE_MCID            0x00000040UL
#define C_SUPPL_SERVICE_CCBS            0x00000080UL
#define C_SUPPL_SERVICE_MWI             0x00000100UL
#define C_SUPPL_SERVICE_CCNR            0x00000200UL
#define C_SUPPL_SERVICE_CONF            0x00000400UL

/* definition of the notification bits for the supplementary services listen */
#define C_SUPPL_LISTEN_INFO_MASK_HOLD_RETRIEVE  0x00000001UL
#define C_SUPPL_LISTEN_INFO_MASK_TERMINAL_PORTAB 0x00000002UL
#define C_SUPPL_LISTEN_INFO_MASK_ECT            0x00000004UL
#define C_SUPPL_LISTEN_INFO_MASK_3PTY           0x00000008UL
#define C_SUPPL_LISTEN_INFO_MASK_CF_CD          0x00000010UL
#define C_SUPPL_LISTEN_INFO_MASK_RESERVED1      0x00000020UL
#define C_SUPPL_LISTEN_INFO_MASK_RESERVED2      0x00000040UL
#define C_SUPPL_LISTEN_INFO_MASK_CCBS           0x00000080UL
#define C_SUPPL_LISTEN_INFO_MASK_MWI            0x00000100UL
#define C_SUPPL_LISTEN_INFO_MASK_CCNR           0x00000200UL
#define C_SUPPL_LISTEN_INFO_MASK_CONF           0x00000400UL

/* definition for the type of call forwarding */
#define C_SUPPL_FORWARD_TYPE_UNCONDITIONAL      0x0000
#define C_SUPPL_FORWARD_TYPE_BUSY               0x0001
#define C_SUPPL_FORWARD_TYPE_NO_REPLY           0x0002

/* definition for the basic service (ETS 300 196-1 [D.5]) */
#define C_SUPPL_BASIC_SVC_ALL_SERVICES          0x0000
#define C_SUPPL_BASIC_SVC_SPEECH                0x0001
#define C_SUPPL_BASIC_SVC_UNRESTRICTED_DATA     0x0002
#define C_SUPPL_BASIC_SVC_3100Hz_AUDIO          0x0003
#define C_SUPPL_BASIC_SVC_UNRESTR_DATA_TONES    0x0004
#define C_SUPPL_BASIC_SVC_3100Hz_TELEPHONY      0x0020
#define C_SUPPL_BASIC_SVC_TELETEX               0x0021
#define C_SUPPL_BASIC_SVC_FAXG4                 0x0022
#define C_SUPPL_BASIC_SVC_VIDEOTEX              0x0023
#define C_SUPPL_BASIC_SVC_VIDEO_TELEPHONY       0x0024
#define C_SUPPL_BASIC_SVC_FAXG3                 0x0025
#define C_SUPPL_BASIC_SVC_7kHz_TELEPHONY        0x0026

/* definition for the presentation of the own number for call deflection */
#define C_SUPPL_PRESENTATION_NOT_ALLOWED        0x0000
#define C_SUPPL_PRESENTATION_ALLOWED            0x0001

/* definition of the reasons for call diversion */
#define C_SUPPL_DIVERT_REASON_UNKNOWN           0x0000
#define C_SUPPL_DIVERT_REASON_CFU               0x0001
#define C_SUPPL_DIVERT_REASON_CFB               0x0002
#define C_SUPPL_DIVERT_REASON_CFNR              0x0003
#define C_SUPPL_DIVERT_REASON_CD_ALERTING       0x0004
#define C_SUPPL_DIVERT_REASON_CD_IMMEDIATE      0x0005

/* definition of the messages status values for MWI message status */
#define C_SUPPL_MWI_MSG_STATUS_ADDED            0x0000
#define C_SUPPL_MWI_MSG_STATUS_REMOVED          0x0001
#define C_SUPPL_MWI_MSG_STATUS_SUPPRESS         0xFFFF

/* definition of the invocation mode for MWI */
#define C_SUPPL_MWI_INVOCATION_MODE_DEFERRED    0x0000
#define C_SUPPL_MWI_INVOCATION_MODE_IMMEDIATE   0x0001
#define C_SUPPL_MWI_INVOCATION_MODE_COMBINED    0x0002
#define C_SUPPL_MWI_INVOCATION_MODE_SUPPRESS    0xFFFF

/* no parameters for Suppl-GetSupportedServices-Request, empty struct */

/* structure of the parameter for Suppl-Listen-Request */
typedef struct CAPISupplParamListenReq
{
   cBYTE  bLength;                      /* length of structure */
   cDWORD dwNotificationMask;           /* bit mask of SUPPL_LISTEN_INFO_MASK_*
                                         */
} CAPISupplParamListenReq_t;

/* no parameters for Suppl-Hold-Request, empty struct */

/* no parameters for Suppl-Retrieve-Request, empty struct */

/* structure of the parameter for Suppl-Suspend-Request */
typedef struct CAPISupplParamSuspendReq
{
   cBYTE      bLength;                  /* length of structure */
/* CAPIStruct CallIdentity;          */ /* Unique identifier (ETS 300 102
                                         * [4.5.6])
                                         */
} CAPISupplParamSuspendReq_t;

/* structure of the parameter for Suppl-Resume-Request */
typedef struct CAPISupplParamResumeReq
{
   cBYTE      bLength;                  /* length of structure */
/* CAPIStruct CallIdentity;          */ /* Unique identifier (ETS 300 102
                                         * [4.5.6])
                                         */
} CAPISupplParamResumeReq_t;

/* structure of the parameter for Suppl-ECT-Request */
typedef struct CAPISupplParamEctReq
{
   cBYTE  bLength;                      /* length of structure */
   cDWORD dwPlci;                       /* call in state P-HELD */
} CAPISupplParamEctReq_t;

/* structure of the parameter for Suppl-3PTY-Begin-Request */
typedef struct CAPISupplParam3PtyBeginReq
{
   cBYTE  bLength;                      /* length of structure */
   cDWORD dwPlci;                       /* call in state P-HELD */
} CAPISupplParam3PtyBeginReq_t;

/* structure of the parameter for Suppl-3PTY-End-Request */
typedef struct CAPISupplParam3PtyEndReq
{
   cBYTE  bLength;                      /* length of structure */
   cDWORD dwPlci;                       /* call in state P-HELD */
} CAPISupplParam3PtyEndReq_t;

/* structure of the parameter for Suppl-CF-Activate-Request */
typedef struct CAPISupplParamCfActivateReq
{
   cBYTE      bLength;                  /* length of structure */
   cDWORD     dwHandle;                 /* unique id for this operation */
   cWORD      wType;                    /* type of forwarding of
                                         * SUPPL_FORWARD_TYPE_*
                                         */
   cWORD      wBasicService;            /* basic service of
                                         * C_SUPPL_BASIC_SVC_*
                                         */
/* CAPIStruct ServedUserNumber;         */
/* CAPIStruct ForwardedToNumber;        */
/* CAPIStruct ForwardedToSubaddress;    */
} CAPISupplParamCfActivateReq_t;

/* structure of the parameter for Suppl-CF-Deactivate-Request */
typedef struct CAPISupplParamCfDeactivateReq
{
   cBYTE      bLength;                  /* length of structure */
   cDWORD     dwHandle;                 /* unique id for this operation */
   cWORD      wType;                    /* type of forwardin of
                                         * SUPPL_FORWARD_TYPE_*
                                         */
   cWORD      wBasicService;            /* basic service of
                                         * C_SUPPL_BASIC_SVC_*
                                         */
/* CAPIStruct ServedUserNumber;         */
} CAPISupplParamCfDeactivateReq_t;

/* structure of the parameter for Suppl-CF-Interrogate-Parameters-Request */
typedef struct CAPISupplParamCfInterrogateParamReq
{
   cBYTE      bLength;                  /* length of structure */
   cDWORD     dwHandle;                 /* unique id for this operation */
   cWORD      wType;                    /* type of forwarding of
                                         * SUPPL_FORWARD_TYPE_*
                                         */
   cWORD      wBasicService;            /* basic service of
                                         * C_SUPPL_BASIC_SVC_*
                                         */
/* CAPIStruct ServedUserNumber;         */
} CAPISupplParamCfInterrogateParamReq_t;

/* structure of the parameter for Suppl-CF-Interrogate-Numbers-Request */
typedef struct CAPISupplParamCfInterrogateNumbersReq
{
   cBYTE  bLength;                      /* length of structure */
   cDWORD dwHandle;                     /* unique id for this operation */
} CAPISupplParamCfInterrogateNumbersReq_t;

/* structure of the parameter for Suppl-CD-Request */
typedef struct CAPISupplParamCdReq
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wPresentationAllowed;     /* value of SUPPL_PRESENTATION_* */
/* CAPIStruct DeflectedToNumber;        */
/* CAPIStruct DeflectedToSubaddress;    */
} CAPISupplParamCdReq_t;

/* no parameters for Suppl-MCID-Request-Request, empty struct */

/* structure of the parameter for Suppl-CCBS-Request-Request */
typedef struct CAPISupplParamCcbsRequestReq
{
   cBYTE  bLength;                      /* length of structure */
   cDWORD dwHandle;                     /* unique id for this operation */
   cWORD  wLinkageID;                   /* CCBS call linkage id as received in
                                         * CCBS info retain indication
                                         */
} CAPISupplParamCcbsRequestReq_t;

/* structure of the parameter for Suppl-CCBS-Deactivate-Request */
typedef struct CAPISupplParamCcbsDeactivateReq
{
   cBYTE  bLength;                      /* length of structure */
   cDWORD dwHandle;                     /* unique id for this operation */
   cWORD  wReference;                   /* CCBS reference as received in CCBS
                                         * info retain indication
                                         */
} CAPISupplParamCcbsDeactivateReq_t;

/* structure of the parameter for Suppl-CCBS-Interrogate-Request */
typedef struct CAPISupplParamCcbsInterrogateReq
{
   cBYTE      bLength;                  /* length of structure */
   cDWORD     dwHandle;                 /* unique id for this operation */
   cWORD      wReference;               /* identifies ring-back */
/* CAPIStruct ServedUserNumber;         */
} CAPISupplParamCcbsInterrogateReq_t;

/* structure of the parameter for Suppl-CCBS-Call-Request */
typedef struct CAPISupplParamCcbsCallReq
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wReference;               /* identifies ring-back */
   cWORD      wCipValue;                /* CIP value of CAPI_CIP_* */
   cWORD      wReserved;                /* reserved ffu. */
/* CAPIStruct BProtocol;                */
/* CAPIStruct BC;                       */
/* CAPIStruct LLC;                      */
/* CAPIStruct HLC;                      */
/* CAPIStruct AdditionalInfo;           */
} CAPISupplParamCcbsCallReq_t;

/* structure of the parameter for Suppl-MWI-Activate-Request */
typedef struct CAPISupplParamMwiActivateReq
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wBasicService;            /* basic service of
                                         * C_SUPPL_BASIC_SVC_*
                                         */
   cDWORD     dwNumMessages;            /* number of messages; 0xFFFFFFFF to
                                         * suppress number of messages
                                         */
   cWORD      wMessageStatus;           /* message status of
                                         * C_SUPPL_MWI_MSG_STATUS_*
                                         */
   cWORD      wReference;               /* unique message reference; only used
                                         * if message status available
                                         */
   cWORD      wInvocationMode;          /* invocation mode of
                                         * C_SUPPL_MWI_INVOCATION_MODE_*
                                         */
/* CAPIStruct ReceivingUserNumber;      */
/* CAPIStruct ControllingUserNumber;    */
/* CAPIStruct ControllingUserProvidedNumber; */
/* CAPIStruct Time;                     */
} CAPISupplParamMwiActivateReq_t;

/* structure of the parameter for Suppl-MWI-Deactivate-Request */
typedef struct CAPISupplParamMwiDeactivateReq
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wBasicService;            /* basic service of
                                         * C_SUPPL_BASIC_SVC_*
                                         */
   cWORD      wInvocationMode;          /* invocation mode of
                                         * C_SUPPL_MWI_INVOCATION_MODE_*
                                         */
/* CAPIStruct ReceivingUserNumber;      */
/* CAPIStruct ControllingUserNumber;    */
} CAPISupplParamMwiDeactivateReq_t;

/* todo: CCNR-Request, CCNR-Interrogate, CONF-Begin, CONF-Add, CONF-Split,
 *       CONF-Drop, CONF-Isolate, CONF-Reattach
 */

/* Note: Most of the parameter structures of the Facility-Confirm for
 *       supplementary services consist only of the info or reason parameter
 *       as the result of the corresponding Facillity-Request. So there is
 *       only a general definition and specialized versions are created if
 *       necessary.
 */

/* structure of the parameter for a general Suppl-Confirm */
typedef struct CAPISupplParamGeneralConf
{
   cBYTE bLength;                       /* length of structure */
   cWORD wInfo;                         /* CAPI info/result value */
} CAPISupplParamGeneralConf_t;

/* structure of the parameter for Suppl-Get-Supported-Serivces-Confirm */
typedef struct CAPISupplParamGetSupportedServicesConf
{
   cBYTE  bLength;                      /* length of structure */
   cWORD  wInfo;                        /* CAPI info/result value */
   cDWORD dwSupportedServices;          /* bit mask of SUPPL_SERVICE_* */
} CAPISupplParamGetSupportedServicesConf_t;

/* structure of the parameter for Suppl-Hold-Indication */
typedef struct CAPISupplParamHoldInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;                       /* CAPI info/result value */
} CAPISupplParamHoldInd_t;

/* structure of the parameter for Suppl-Retrieve-Indication */
typedef struct CAPISupplParamRetrieveInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParamRetrieveInd_t;

/* structure of the parameter for Suppl-Suspend-Indication */
typedef struct CAPISupplParamSuspendInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParamSuspendInd_t;

/* structure of the parameter for Suppl-Resume-Indication */
typedef struct CAPISupplParamResumeInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParamResumeInd_t;

/* structure of the parameter for Suppl-ECT-Indication */
typedef struct CAPISupplParamEctInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParamEctInd_t;

/* structure of the parameter for Suppl-3PTY-Begin-Indication */
typedef struct CAPISupplParam3PtyBeginInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParam3PtyBeginInd_t;

/* structure of the parameter for Suppl-3PTY-End-Indication */
typedef struct CAPISupplParam3PtyEndInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParam3PtyEndInd_t;

/* structure of the parameter for Suppl-CF-Activate-Indication */
typedef struct CAPISupplParamCfActivateInd
{
   cBYTE  bLength;                      /* length of structure */
   cWORD  wReason;
   cDWORD dwHandle;
} CAPISupplParamCfActivateInd_t;

/* structure of the parameter for Suppl-CF-Deactivate-Indication */
typedef struct CAPISupplParamCfDeactivateInd
{
   cBYTE  bLength;                      /* length of structure */
   cWORD  wReason;
   cDWORD dwHandle;
} CAPISupplParamCfDeactivateInd_t;

/* structure of the parameter for Suppl-CF-Interrogate-Parameters-Indication */
typedef struct CAPISupplParamCfInterrogateParamInd
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wReason;
   cDWORD     dwHandle;
/* CAPIStruct Instances;                */
} CAPISupplParamCfInterrogateParamInd_t;

/* structure of the parameter for Suppl-CF-Interrogate-Numbers-Indication */
typedef struct CAPISupplParamCfInterrogateNumbersInd
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wReason;
   cDWORD     dwHandle;
/* CAPIStruct ServedUserNumbers;        */
} CAPISupplParamCfInterrogateNumbersInd_t;

/* structure of the parameter for Suppl-CD-Indication */
typedef struct CAPISupplParamCdInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParamCdInd_t;

/* structure of the parameter for Suppl-MCID-Request-Indication */
typedef struct CAPISupplParamMcidRequestInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParamMcidRequestInd_t;

/* todo: CCBS-Request, CCBS-Deactivate, CCBS-Interrogate, CCBS-Call */

/* structure of the parameter for Suppl-MWI-Activate-Indication */
typedef struct CAPISupplParamMwiActivateInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParamMwiActivateInd_t;

/* structure of the parameter for Suppl-MWI-Deactivate-Indication */
typedef struct CAPISupplParamMwiDeactivateInd
{
   cBYTE bLength;                       /* length of structure */
   cWORD wReason;
} CAPISupplParamMwiDeactivateInd_t;

/* todo: CCNR-Request, CCNR-Interrogate, CONF-Begin, CONF-Add, CONF-Split,
 *       CONF-Drop, CONF-Isolate, CONF-Reattach
 */

/* no parameters for Suppl-Hold-Notification, empty struct */

/* no parameters for Suppl-Retrieve-Notification, empty struct */

/* no parameters for Suppl-Suspend-Notification, empty struct */

/* no parameters for Suppl-Resume-Notification, empty struct */

/* no parameters for Suppl-Call-Beeing-Diverted-Notification, empty struct */

/* no parameters for Suppl-Diversion-Activated-Notification, empty struct */

/* structure of the parameter for Suppl-CF-Activate-Notification */
typedef struct CAPISupplParamCfActivateNotification
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wType;                    /* type of forwarding of
                                         * SUPPL_FORWARD_TYPE_*
                                         */
   cWORD      wBasicService;            /* basic service of
                                         * C_SUPPL_BASIC_SVC_*
                                         */
/* CAPIStruct ServedUserNumber;         */
/* CAPIStruct ForwardedToAddress;       */
/* CAPIStruct ForwardedToSubaddress;    */
} CAPISupplParamCfActivateNotification_t;

/* structure of the parameter for Suppl-CF-Deactivate-Notification */
typedef struct CAPISupplParamCfDeactivateNotification
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wType;                    /* type of forwarding of
                                         * SUPPL_FORWARD_TYPE_*
                                         */
   cWORD      wBasicService;            /* basic service of
                                         * C_SUPPL_BASIC_SVC_*
                                         */
/* CAPIStruct ServedUserNumber;         */
} CAPISupplParamCfDeactivateNotification_t;

/* structure of the parameter for Suppl-Diversion-Info-Notification */
typedef struct CAPISupplParamDiversionInfoNotification
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wBasicService;            /* basic service of
                                         * C_SUPPL_BASIC_SVC_*
                                         */
   cWORD      wDiversionReason;         /* value of SUPPL_DIVERT_REASON_* */
   cWORD      wLastDivertingReason;     /* value of SUPPL_DIVERT_REASON_* */
/* CAPIStruct ServedUserSubaddress;     */
/* CAPIStruct CallingNumber;            */
/* CAPIStruct CallingSubaddress;        */
/* CAPIStruct OriginalCalledNumber;     */
/* CAPIStruct LastDivertingNumber;      */
} CAPISupplParamDiversionInfoNotification_t;

/* todo: Call-Transfer-Alerted-Notification,
 *       Call-Transfer-Active-Notification,
 *       Conference-Established-Notification,
 *       Conference-Disconnect-Notification,
 *       CCBS-Erase-Call-Linkage-ID-Notification,
 *       CCBS-Status-Notification,
 *       CCBS-Remote-User-Free-Notification,
 *       CCBS-B-Free-Notification,
 *       CCBS-Erase-Notification,
 *       CCBS-Stop-Alerting-Notification,
 *       CCBS-Info-Retain
 */

/* structure of the parameter for Suppl-MWI-Indication-Notification */
typedef struct CAPISupplParamMwiIndNotification
{
   cBYTE      bLength;                  /* length of structure */
   cWORD      wBasicService;            /* basic service of
                                         * C_SUPPL_BASIC_SVC_*
                                         */
   cDWORD     dwNumMessages;            /* number of messages;
                                         * 0xFFFFFFFE: unknown no. messages
                                         * 0xFFFFFFFF: no. messages not
                                         *    available
                                         */
   cWORD      wMessageStatus;           /* message status of
                                         * C_SUPPL_MWI_MSG_STATUS_*
                                         */
   cWORD      wReference;               /* unique message reference; only
                                         * valid if message status available
                                         */
/* CAPIStruct ControllingUserNumber;    */
/* CAPIStruct ControllingUserProvidedNumber; */
/* CAPIStruct Time;                     */
/* CAPIStruct CalledPartyNumber;        */
} CAPISupplParamMwiIndNotification_t;

/* todo: CCNR-Info-Retain-Notification,
 *       CONF-Party-Disconnect-Notification,
 *       CONF-Notifications-Notification
 */

/* no parameters for Suppl-Hold-Response, empty struct */

/* no parameters for Suppl-Retrieve-Response, empty struct */

/* no parameters for Suppl-Suspend-Response, empty struct */

/* no parameters for Suppl-Resume-Response, empty struct */

/* no parameters for Suppl-ECT-Response, empty struct */

/* no parameters for Suppl-3PTY-Begin-Response, empty struct */

/* no parameters for Suppl-3PTY-End-Response, empty struct */

/* no parameters for Suppl-CF-Activate-Response, empty struct */

/* no parameters for Suppl-CF-Deactivate-Response, empty struct */

/* no parameters for Suppl-CF-Interrogate-Parameters-Response, empty struct */

/* no parameters for Suppl-CF-Interrogate-Numbers-Response, empty struct */

/* no parameters for Suppl-CD-Response, empty struct */

/* no parameters for Suppl-MCID-Response, empty struct */

/* no parameters for Suppl-CCBS-Request-Response, empty struct */

/* no parameters for Suppl-CCBS-Deactivate-Response, empty struct */

/* no parameters for Suppl-CCBS-Interrogate-Response, empty struct */

/* no parameters for Suppl-CCBS-Call-Response, empty struct */

/* no parameters for Suppl-MWI-Activate-Response, empty struct */

/* no parameters for Suppl-MWI-Deactivate-Response, empty struct */

/* no parameters for Suppl-CCNR-Request-Response, empty struct */

/* no parameters for Suppl-CCNR-Interrogate-Response, empty struct */

/* no parameters for Suppl-CONF-Begin-Response, empty struct */

/* no parameters for Suppl-CONF-Add-Response, empty struct */

/* no parameters for Suppl-CONF-Split-Response, empty struct */

/* no parameters for Suppl-CONF-Drop-Response, empty struct */

/* no parameters for Suppl-CONF-Isolate-Response, empty struct */

/* no parameters for Suppl-CONF-Reattach-Response, empty struct */

/* no parameters for Suppl-Hold-Notification-Response, empty struct */

/* no parameters for Suppl-Retrieve-Notification-Response, empty struct */

/* no parameters for Suppl-Suspend-Notification-Response, empty struct */

/* no parameters for Suppl-Resume-Notification-Response, empty struct */

/* no parameters for Suppl-Call-Is-Diverting-Notification-Response, empty struct */

/* no parameters for Suppl-Diversion-Activated-Notification-Response, empty struct */

/* no parameters for Suppl-CF-Activate-Notification-Response, empty struct */

/* no parameters for Suppl-CF-Deactivate-Notification-Response, empty struct */

/* no parameters for Suppl-Diversion-Information-Notification-Response, empty struct */

/* no parameters for Suppl-Call-Transfer-Alerted-Notification-Response, empty struct */

/* no parameters for Suppl-Call-Transfer-Active-Notification-Response, empty struct */

/* no parameters for Suppl-Conference-Established-Notification-Response, empty struct */

/* no parameters for Suppl-Conference-Disconnect-Notification-Response, empty struct */

/* no parameters for Suppl-CCBS-Erase-Call-Linkage-ID-Notification-Response, empty struct */

/* structure of the parameter for Suppl-CCBS-Status-Notification-Response */
typedef struct CAPISupplParamCcbsStatusNotificationResp
{
   cBYTE bLength;                       /* length of structure */
   cWORD wStatusReport;                 /* current application status */
} CAPISupplParamCcbsStatusNotificationResp_t;

/* no parameters for Suppl-CCBS-Remote-User-Free-Notification-Response, empty struct */

/* no parameters for Suppl-CCBS-B-Free-Notification-Response, empty struct */

/* no parameters for Suppl-CCBS-Stop-Alerting-Notification-Response, empty struct */

/* no parameters for Suppl-CCBS-Info-Retain-Notification-Response, empty struct */

/* no parameters for Suppl-MWI-Indication-Notification-Response, empty struct */

/* no parameters for Suppl-CCNR-Info-Retain-Notification-Response, empty struct */

/* no parameters for Suppl-CONF-Party-Disconnect-Notification-Response, empty struct */

/* no parameters for Suppl-CONF-Notifications-Notification-Response, empty struct */



#include <capi_pack_off.h>





/* === prototypes of interface functions ================================= */





#endif /* __CAPI_SUPPLSVC_H */
