/**
 * @file ix1a_cfgdefs.h
 *
 * IX1A-ConfigDefinitions - Section and key names for an IX1 active
 * configuration file.
 *
 * Copyright: 2005 Thomas Wintergerst. All rights reserved.
 *
 * $Id: ix1a_cfgdefs.h,v 1.2.2.1 2005/05/27 16:29:10 thomas Exp $
 * $Project:    CAPI for BSD $
 * $Target:     IX1 active ISDN boards control program $
 * @date        09.01.2005
 * @author      "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef IX1A_CFGDEFS_H
#define IX1A_CFGDEFS_H





// === Public declarations ===============================================





/// @name Section names for the configuration file
/// @{

/// The name of the section for global settings.
#define IX1A_CFG_SECT_GLOBAL            "global"

/// The name of the section for the boards.
#define IX1A_CFG_SECT_BOARDS            "boards"

/// The name of the boards sub-section for general parameters.
#define IX1A_CFG_SECT_GENERAL           "general"

/// The name of the boards sub-section for the line ports, must be completed
/// with the (0-based) port index number.
#define IX1A_CFG_SECT_PORT              "port-"

/// The name of a port's sub-section for line access parameters.
#define IX1A_CFG_SECT_LINE_ACCESS       "line-access"

/// The name of a port's sub-section for Primary-specific settings.
#define IX1A_CFG_SECT_PMX_SETTINGS      "pmx"

/// The name of a port's service profile parameters.
#define IX1A_CFG_SECT_SPID_SETTINGS     "spid-settings"

/// @}



/// @name Key names for the global section of the configuration file
/// @{

/// The key string for the firmware base directory.
#define IX1A_CFG_KEY_BASE_DIRECTORY     "BaseDir"

/// @}



/// @name Key names for the top level boards section of the configuration file
/// @{

/// The key string for the boot code file name.
#define IX1A_CFG_KEY_BOOT_FILE          "bootcode"

/// The key string for the firmware code file name.
#define IX1A_CFG_KEY_FIRMWARE_FILE      "firmware"


/// @}



/// @name Key names for a board's general parameters section
/// @{

/// The key string for the MVIP type.
#define IX1A_CFG_KEY_MVIP_TYPE          "MvipType"

/// The key string for the voice coding setting.
#define IX1A_CFG_KEY_VOICE_CODING       "VoiceCoding"

/// The key string for the Multimodem country version setting.
#define IX1A_CFG_KEY_COUNTRY_VERSION    "CountryVersion"

/// The key string for the compression usage.
#define IX1A_CFG_KEY_COMPRESSION        "Compression"

/// @}



/// @name Key names for a port's line access parameters section
/// @{

/// The key string for the D-channel protocol setting.
#define IX1A_CFG_KEY_DCHAN_PROTOCOL     "DProtocol"

/// The key string for the line access setting.
#define IX1A_CFG_KEY_LINE_ACCESS        "LineAccess"

/// The key string for the line type setting.
#define IX1A_CFG_KEY_LINE_TYPE          "LineType"

/// The key string for the type of a leased line.
#define IX1A_CFG_KEY_LEASED_LINE_TYPE   "LeasedLineType"

/// The key string for the TEI assignment setting.
#define IX1A_CFG_KEY_TEI_TYPE           "TeiType"

/// The key string for the TEI value.
#define IX1A_CFG_KEY_TEI_VALUE          "TeiValue"

/// The key string for TE operation or NT emulation.
#define IX1A_CFG_KEY_NT_TE_MODE         "NtTeMode"

/// @}



/// @name Key names for a port's Primary-specific parameters section
/// @{

/// The key string for the clock generator configuration.
#define IX1A_CFG_KEY_CLOCK_GENERATOR    "ClockGenerator"

/// The key string for the first B-channel timeslot to use.
#define IX1A_CFG_KEY_FIRST_BCHAN        "FirstBChan"

/// The key string for the last B-channel timeslot to use.
#define IX1A_CFG_KEY_LAST_BCHAN         "LastBChan"

/// The key string for the B-channel selection setting.
#define IX1A_CFG_KEY_BCHAN_SELECTION    "BChanSelection"

/// The key string for setting the line to E1 or T1 operation.
#define IX1A_CFG_KEY_LINE_RATE          "LineRate"

/// The key string for setting the bit coding on the line.
#define IX1A_CFG_KEY_LINE_CODE          "LineCode"

/// The key string for the framing format.
#define IX1A_CFG_KEY_FRAMING_FORMAT     "FramingFormat"

/// The key string for the DSX pre-emphasis for T1 lines.
#define IX1A_CFG_KEY_DSX_PRE_EMPHASIS   "DsxPreEmphasis"

/// @}



/// @name Key names for a port's SPID settings (north american D-channel protocols)
/// @{

/// The key string for switching SPID1 for data on or off.
#define IX1A_CFG_KEY_SPID1_DATA_ON      "Spid1DataOn"

/// The key string for switching SPID2 for data on or off.
#define IX1A_CFG_KEY_SPID2_DATA_ON      "Spid2DataOn"

/// The key string for switching the SPID1 for voice on or off.
#define IX1A_CFG_KEY_SPID1_VOICE_ON     "Spid1VoiceOn"

/// The key string for switching the SPID2 for voice on or off.
#define IX1A_CFG_KEY_SPID2_VOICE_ON     "Spid2VoiceOn"

/// n.d.
#define IX1A_CFG_KEY_SIGNAL_DN2_AS_DN1  "SignalDn2AsDn1"

/// n.d.
#define IX1A_CFG_KEY_SIGNAL_ADD_DN1_AS_DN1      "SignalAddDn1AsDn1"

/// n.d.
#define IX1A_CFG_KEY_SIGNAL_ADD_DN2_AS_DN2      "SignalAddDn2AsDn2"

/// The key string for the SPID of the 1st B-channel.
#define IX1A_CFG_KEY_SPID1              "Spid1"

/// The key string for the SPID of the 2nd B-channel.
#define IX1A_CFG_KEY_SPID2              "Spid2"

/// The key string for the primary directory number of the 1st B-channel.
#define IX1A_CFG_KEY_DN1                "Dn1"

/// The key string for the primary directory number of the 2nd B-channel.
#define IX1A_CFG_KEY_DN2                "Dn2"

/// The key string for the 1st additional DN of the 1st B-channel.
#define IX1A_CFG_KEY_DN1_ADD1           "Dn1Add1"

/// The key string for the 2nd additional DN of the 1st B-channel.
#define IX1A_CFG_KEY_DN1_ADD2           "Dn1Add2"

/// The key string for the 3rd additional DN of the 1st B-channel.
#define IX1A_CFG_KEY_DN1_ADD3           "Dn1Add3"

/// The key string for the 4th additional DN of the 1st B-channel.
#define IX1A_CFG_KEY_DN1_ADD4           "Dn1Add4"

/// The key string for the 1st additional DN of the 2nd B-channel.
#define IX1A_CFG_KEY_DN2_ADD1           "Dn2Add1"

/// The key string for the 2nd additional DN of the 2nd B-channel.
#define IX1A_CFG_KEY_DN2_ADD2           "Dn2Add2"

/// The key string for the 3rd additional DN of the 2nd B-channel.
#define IX1A_CFG_KEY_DN2_ADD3           "Dn2Add3"

/// The key string for the 4th additional DN of the 2nd B-channel.
#define IX1A_CFG_KEY_DN2_ADD4           "Dn2Add4"

/// @}



/// @name Comment strings for section names for the configuration file
/// @{

/// The name of the section for global settings.
#define IX1A_COMMENT_SECT_GLOBAL \
   ";\n" \
   "; Global settings common to all boards\n" \
   ";\n"

/// The name of the section for the boards.
#define IX1A_COMMENT_SECT_BOARDS \
   ";\n" \
   "; Section containing all IX1 active ISDN boards\n" \
   ";\n"

/// The name of the boards sub-section for general parameters.
#define IX1A_COMMENT_SECT_GENERAL \
   ";\n" \
   "; General settings for the board\n" \
   ";\n"

/// The name of the boards sub-section for the line ports, must be completed
/// with the (1-based) port index number.
#define IX1A_COMMENT_SECT_PORT \
   ";\n" \
   "; Line port specific settings\n" \
   ";\n"

/// The name of a port's sub-section for line access parameters.
#define IX1A_COMMENT_SECT_LINE_ACCESS \
   ";\n" \
   "; Line access parameters\n" \
   ";\n"

/// The name of a port's sub-section for Primary-specific settings.
#define IX1A_COMMENT_SECT_PMX_SETTINGS \
   ";\n" \
   "; Primary board specific settings\n" \
   ";\n"

/// The name of a port's service profile parameters.
#define IX1A_COMMENT_SECT_SPID_SETTINGS \
   ";\n" \
   "; Service profile settings for north American D-channel protocols.\n" \
   "; Leave everything unset for other D-channel protocols and Primary boards.\n" \
   "; For the correct settings for the fields ask Your local carrier.\n"

/// @}



/// @name Comment strings for keys of the global section of the configuration file
/// @{

/// The key string for the firmware base directory.
#define IX1A_COMMENT_KEY_BASE_DIRECTORY \
   ";\n" \
   "; The base directory for boot code and firmware files used throughout this\n" \
   "; file within the boards' sections\n"

/// @}



/// @name Comment strings for keys of the top level boards section of the configuration file
/// @{

/// The key string for the boot code file name.
#define IX1A_COMMENT_KEY_BOOT_FILE \
   ";\n" \
   "; The name of the boot code file, relative to the base directory.\n" \
   "; Note: Must not be set for Primary boards.\n"

/// The key string for the firmware code file name.
#define IX1A_COMMENT_KEY_FIRMWARE_FILE \
   ";\n" \
   "; The name of the firmware file for the board, relative to the base directory.\n"


/// @}



/// @name Comment strings for keys of board's general parameters section
/// @{

/// The key string for the MVIP type.
#define IX1A_COMMENT_KEY_MVIP_TYPE \
   ";\n" \
   "; MVIP type setting for boards with an MVIP bus (Octo, Primary, Multimodem).\n" \
   "; 0=default, 1=master, 2=slave\n"

/// The key string for the voice coding setting.
#define IX1A_COMMENT_KEY_VOICE_CODING \
   ";\n" \
   "; Voice coding law.\n" \
   "; 0=default for D-channel protocol, 1=a-Law (Europe and most countries),\n" \
   "; 2=-Law (north America and Japan)\n"

/// The key string for the Multimodem country version setting.
#define IX1A_COMMENT_KEY_COUNTRY_VERSION \
   ";\n" \
   "; Multimodem country adaption (not used by other boards).\n" \
   "; Note: Some of the country names below are obsolete, because they originate\n" \
   ";       from older documentation. See the Rockwell AT reference manual.\n" \
   "; 0=default, 1=Austria, 2=Belgium, 3=Denmark, 4=Finland, 5=France,\n" \
   "; 6=Germany, 7=Ireland, 8=Italy, 9=Luxembourg, 10=Netherlands,\n" \
   "; 11=Norway, 12=Portugal, 13=Spain, 14=Sweden, 15=Switzerland,\n" \
   "; 16=United Kingdom, 17=Greece, 18=Israel, 19=Czech Republic, 20=Canada,\n" \
   "; 21=Mexiko, 22=United States, 23=Hungary, 24=Poland, 25=Russia,\n" \
   "; 26=Slovac Republic, 27=Bulgaria, 40=Australia, 43=Japan, 47=Singapore,\n" \
   "; 48=New Zealand\n"

/// The key string for the compression usage.
#define IX1A_COMMENT_KEY_COMPRESSION \
   ";\n" \
   "; Compression to use for X.75 connections.\n" \
   "; 0=default, 1=none, 2=V.42bis, 3=ITK-specific compression,\n" \
   "; 4=optional compression to be acknowledged by both connection partners,\n" \
   "; 5=CAPIPlus defined\n"

/// @}



/// @name Comment strings for keys of a port's line access parameters section
/// @{

/// The key string for the D-channel protocol setting.
#define IX1A_COMMENT_KEY_DCHAN_PROTOCOL \
   ";\n" \
   "; D-channel protocol to use.\n" \
   "; 0=default, 1=1TR6, 2=DSS1 / Euro-ISDN / NET3 / ETSI, 3=VN2 (France),\n" \
   "; 4=VN3 (France), 5=5ESS (AT&T / USA), 6=DSS1 PBX (with SETUP-ACK),\n" \
   "; 7=DMS-100 (USA), 8=CORNET-N (Siemens PBX), 9=DSS1 (Norway Phase 1),\n" \
   "; 10=CORNET-T (Siemens PBX), 11=National ISDN 1 (USA, NI1),\n" \
   "; 12=Q.931 Blue Book (CCITT), 13=Q.Sig, 15=TS013 / TS014 (Australia),\n" \
   "; 16=DSS1 for Netherlands (with type=national),\n" \
   "; 17=DSS1 PBX with no sending complete, 21=DSS1 with no RESTART,\n" \
   "; 22=4ESS (USA, AT&T - T1 long distance)\n"

/// The key string for the line access setting.
#define IX1A_COMMENT_KEY_LINE_ACCESS \
   ";\n" \
   "; Line access setting.\n" \
   "; 0=default for board type, 1=Point-to-Multipoint, 2=Point-to-Point\n"

/// The key string for the line type setting.
#define IX1A_COMMENT_KEY_LINE_TYPE \
   ";\n" \
   "; Line type.\n" \
   "; 0=default, 1=switched line, 2=leased line\n"

/// The key string for the type of a leased line.
#define IX1A_COMMENT_KEY_LEASED_LINE_TYPE \
   ";\n" \
   "; Leased line type if line type is \"leased line\"\n" \
   "; 0=default, 1=single B-channel with D-channel,\n" \
   "; 2=single B-channel without D-channel, 3=bundled B-channels with D-channel,\n" \
   "; 4=bundled B-channels without D-channel\n"

/// The key string for the TEI assignment setting.
#define IX1A_COMMENT_KEY_TEI_TYPE \
   ";\n" \
   "; Type of TEI assignment.\n" \
   "; 0=default for board type, 1=automatic TEI assginment (multipoint),\n" \
   "; 2=fixed TEI (point-to-point)\n"

/// The key string for the TEI value.
#define IX1A_COMMENT_KEY_TEI_VALUE \
   ";\n" \
   "; TEI value for fixed TEI setting. 0-63 are possible values.\n"

/// The key string for TE operation or NT emulation.
#define IX1A_COMMENT_KEY_NT_TE_MODE \
   ";\n" \
   "; Select TE mode (terminal mode) or NT emulation (network emulation).\n" \
   "; 0=default, 1=TE side, 2=NT side\n"

/// @}



/// @name Comment strings for keys of a port's Primary-specific parameters section
/// @{

/// The key string for the clock generator configuration.
#define IX1A_COMMENT_KEY_CLOCK_GENERATOR \
   ";\n" \
   "; Clock generator setting.\n" \
   "; 0=default, 1=clock from line, 2=clock from board\n"

/// The key string for the first B-channel timeslot to use.
#define IX1A_COMMENT_KEY_FIRST_BCHAN \
   ";\n" \
   "; Number of the first B-channel to use.\n" \
   "; 0=default (no limitation), 1-30 (for E1) or 1-23 (for T1) for the\n" \
   "; lowest B-channel timeslot number to use\n"

/// The key string for the last B-channel timeslot to use.
#define IX1A_COMMENT_KEY_LAST_BCHAN \
   ";\n" \
   "; Number of the last B-channel to use.\n" \
   "; 0=default (no limitation), 1-30 (for E1) or 1-23 (for T1) for the\n" \
   "; highest B-channel timeslot number to use\n"

/// The key string for the B-channel selection setting.
#define IX1A_COMMENT_KEY_BCHAN_SELECTION \
   ";\n" \
   "; Algorithm used for selecting the B-channels to use for calls\n" \
   "; 0=default, 1=Round Robin up, 2=Round Robin down, 3=fixed up, 4=fixed down\n"

/// The key string for setting the line to E1 or T1 operation.
#define IX1A_COMMENT_KEY_LINE_RATE \
   ";\n" \
   "; Selecting E1 (30 B-channels) or T1 (23 B-channels) operation.\n" \
   "; 0=default, 1=E1, 2=T2\n"

/// The key string for setting the bit coding on the line.
#define IX1A_COMMENT_KEY_LINE_CODE \
   ";\n" \
   "; Bit coding used on the line.\n" \
   "; 0=default, 1=B8ZS (T1 only), 2=AMI with ZCS (T1 only),\n" \
   "; 3=HDB3 (E1 only), 4=AMI (E1 only)\n"

/// The key string for the framing format.
#define IX1A_COMMENT_KEY_FRAMING_FORMAT \
   ";\n" \
   "; Framing format used on the line.\n" \
   "; 0=default, 1=ESF (T1 only), 2=SF (D3/D4, T1 only), 3=F4 (T1 only),\n" \
   "; 4=F72 (T1 only), 5=CRC4 multi frame (E1 only), 6=double frame (E1 only)\n"

/// The key string for the DSX pre-emphasis for T1 lines.
#define IX1A_COMMENT_KEY_DSX_PRE_EMPHASIS \
   ";\n" \
   "; DSX preemphasis for long cables.\n" \
   "; 0=default, 1=0-115 feet, 2=82-213 feed, 3=180-312 feed, 4=279-410 feed,\n" \
   "; 5=377-509 feet, 6=476-607 feet, 7=574-689 feet, 8=18db\n"

/// @}



/// @name Key names for a port's SPID settings (north american D-channel protocols)
/// @{

/// The key string for switching SPID1 for data on or off.
#define IX1A_COMMENT_KEY_SPID1_DATA_ON  ""

/// The key string for switching SPID2 for data on or off.
#define IX1A_COMMENT_KEY_SPID2_DATA_ON  ""

/// The key string for switching the SPID1 for voice on or off.
#define IX1A_COMMENT_KEY_SPID1_VOICE_ON ""

/// The key string for switching the SPID2 for voice on or off.
#define IX1A_COMMENT_KEY_SPID2_VOICE_ON ""

/// n.d.
#define IX1A_COMMENT_KEY_SIGNAL_DN2_AS_DN1      ""

/// n.d.
#define IX1A_COMMENT_KEY_SIGNAL_ADD_DN1_AS_DN1  ""

/// n.d.
#define IX1A_COMMENT_KEY_SIGNAL_ADD_DN2_AS_DN2  ""

/// The key string for the SPID of the 1st B-channel.
#define IX1A_COMMENT_KEY_SPID1          ""

/// The key string for the SPID of the 2nd B-channel.
#define IX1A_COMMENT_KEY_SPID2          ""

/// The key string for the primary directory number of the 1st B-channel.
#define IX1A_COMMENT_KEY_DN1            ""

/// The key string for the primary directory number of the 2nd B-channel.
#define IX1A_COMMENT_KEY_DN2            ""

/// The key string for the 1st additional DN of the 1st B-channel.
#define IX1A_COMMENT_KEY_DN1_ADD1       ""

/// The key string for the 2nd additional DN of the 1st B-channel.
#define IX1A_COMMENT_KEY_DN1_ADD2       ""

/// The key string for the 3rd additional DN of the 1st B-channel.
#define IX1A_COMMENT_KEY_DN1_ADD3       ""

/// The key string for the 4th additional DN of the 1st B-channel.
#define IX1A_COMMENT_KEY_DN1_ADD4       ""

/// The key string for the 1st additional DN of the 2nd B-channel.
#define IX1A_COMMENT_KEY_DN2_ADD1       ""

/// The key string for the 2nd additional DN of the 2nd B-channel.
#define IX1A_COMMENT_KEY_DN2_ADD2       ""

/// The key string for the 3rd additional DN of the 2nd B-channel.
#define IX1A_COMMENT_KEY_DN2_ADD3       ""

/// The key string for the 4th additional DN of the 2nd B-channel.
#define IX1A_COMMENT_KEY_DN2_ADD4       ""

/// @}





// === Class declarations ================================================





// === Prototypes of interface functions =================================





#endif /* IX1A_CFGDEFS_H */
