/**
 * @file kcapi_appl.h
 *
 * KCapi-Application - kernel CAPI manager for *BSD: Internal interface for CAPI
 * application handling.
 *
 * Copyright: 2000-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: kcapi_appl.h,v 1.8.4.1 2005/05/27 16:29:12 thomas Exp $
 * Project  CAPI for BSD
 * Target   kcapimgr - The CAPI manager for *BSD
 * @date    01.01.2000
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __KCAPI_APPL_H
#define __KCAPI_APPL_H





/* === public declarations =============================================== */





/* === prototypes of interface functions ================================= */





/* --- initialization and close of this module --- */

/**
 * Initialize the application handling module.
 */
extern void kcapiappl_init (void);

/**
 * Close the application handling module.
 */
extern void kcapiappl_close (void);



/* --- receiving a CAPI message --- */

/**
 * Signal a received CAPI message for a connection.
 *
 * This function is called by the controller handling module to forward a CAPI
 * message from a controller. So this function must first obtain access to the
 * application data array. Then the call may be forwarded to the internal
 * function to enqueue the message for the application.
 *
 * @param uApplID               I: The application id to forward the message to.
 * @param pmbMsg                I: The mbuf containing the CAPI message.
 *
 * @return Nothing.
 */
extern void kcapiappl_enqueue_capi_message
   (unsigned     uApplID,
    struct mbuf *pmbMsg);

/**
 * Signal a trace message to an application.
 *
 * This function is called by the tracing module to forward a CAPI message from
 * with tracing content. So this function must first obtain access to the
 * application data array. Then the trace message is enqueued into the trace
 * queue for the addressed application. Finally the callback function is called
 * to tell the application there is a new message to retrieve.
 *
 * @param uApplID               I: The application id to forward the message to.
 * @param pmbMsg                I: The mbuf containing the trace message.
 *
 * @return Nothing.
 */
extern void kcapiappl_enqueue_trace_message
   (unsigned     uApplID,
    struct mbuf *pmbMsg);


/* --- special notifications from the controller handling module --- */

/**
 * Signal disabling of a controller.
 */
extern void kcapiappl_notify_ctlr_disable
   (unsigned uCtlr);





/* === definition of inline functions ==================================== */





#endif /* __KCAPI_APPL_H */
