/**
 * @file kcapimgr_global.h
 *
 * KCapiMgr-Global - Definitions for internal use in the CAPI manager.
 *
 * Copyright: 2000-2003 Thomas Wintergerst. All rights reserved.
 *
 * $FreeBSD$
 * $Id: kcapimgr_global.h,v 1.21.2.1 2005/05/27 16:29:14 thomas Exp $
 * Project  CAPI for BSD
 * Target   kcapimgr - The CAPI manager for *BSD
 * @date    12.08.2002
 * @author  "Thomas Wintergerst" <twinterg@gmx.de>
 * <p>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * </p>
 */

#ifndef __KCAPIMGR_GLOBAL_H
#define __KCAPIMGR_GLOBAL_H





/* === public declarations =============================================== */





/* --- several constants --- */

/** The name of the CAPI manager kernel module. */
#define CAPIMAN_MODULE_NAME     "kcapimgr"

/* the manufacturer string of the CAPI manager */
#define CAPIMAN_MANUFACTURER_STRING     "Thomas Wintergerst, GojH"

/* the maximum number of supported CAPI applications (minus 1, entry at index
 * zero will not be used)
 */
#define CAPI_MAX_APPLICATIONS   128

/* the maximum number of CAPI controller is 127, starting at 1, entry at index
 * zero will not be used
 */
#define CAPI_MAX_CONTROLLERS    128

/* the maximum number of B-channels for a ISDN controller */
#define CAPI_MAX_NUM_BCHANNELS_PER_CTLR 30

/** The window size for outgoing data blocks. */
#define CAPIMAN_OUT_WINDOW_SIZE 8

/** The name for the logging mask as a tunable kernel parameter. */
#define CAPIMAN_TUNABLE_LOGLEVEL \
   "capi." CAPIMAN_MODULE_NAME ".loglevel"



/* --- definitions for dynamic memory allocation --- */

/* the following tag will be used when allocating memory for use in the kernel
 * CAPI manager
 */
MALLOC_DECLARE (M_KCAPIMGRBUF);



/* --- some global counters available to all modules --- */

/* Note: These values are only updated through the atomic functions. So it is
 *       always safe to read the value without acquiring a mutex.
 */

/** The current number of registered applications. */
extern unsigned e_uNumApps;

/** The current number of registered controllers. */
extern unsigned e_uNumCtlrs;

/** The current number of registered tracers. */
extern unsigned e_uNumTracers;



/* --- Compatibility macros for ifqueue access --- */

#define IF_QINIT( ifq, pszName, uMaxLen, fRecurse )      \
   do                                                    \
   {                                                     \
      _IF_QINIT (ifq, uMaxLen);                          \
      mtx_init (&((ifq)->ifq_mtx), pszName, NULL,        \
                MTX_DEF | (fRecurse ? MTX_RECURSE : 0)); \
   } while (0)

#define IF_QDESTROY( ifq ) \
   IF_DRAIN (ifq);         \
   mtx_destroy (&((ifq)->ifq_mtx));

#define IF_ENQUEUE_MTX( ifq, pmb ) \
   IF_ENQUEUE (ifq, pmb)

#define IF_DEQUEUE_MTX( ifq, pmb ) \
   IF_DEQUEUE (ifq, pmb)

#define _IF_QINIT( ifq, uMaxLen )     \
   do                                 \
   {                                  \
      bzero ((ifq), sizeof (*(ifq))); \
      (ifq)->ifq_maxlen = (uMaxLen);  \
   } while (0)



/* --- some helper macros --- */

#define ARRAY_COUNT( a )        (sizeof (a) / sizeof (a [0]))



/* --- the logging functionality --- */

/** The logging levels supported. */
#define LOG_ALWAYS      0
#define LOG_ERROR       1
#define LOG_INFO        2
#define LOG_TRACE       3
#define LOG_DEBUG       4

/**
 * Characters to mark log messages with their severity.
 *
 * @note The array-string is indexed by the log level.
 */
#define LOG_CHARS       "AEMTD"

/** The current logging level. */
extern int e_iKCapiMgrLogLevel;

/** The macro for log output. */
#define DBG( level, fmt, args... )                        \
   if ((level) <= e_iKCapiMgrLogLevel)                    \
   {                                                      \
      printf ("kcapimgr: %c %s: " fmt "\n",               \
              LOG_CHARS [level], __FUNCTION__ , ## args); \
   }





/* === prototypes of interface functions ================================= */





/* === definition of inline functions ==================================== */





#endif /* __KCAPIMGR_GLOBAL_H */
