#!/bin/sh
#
# Shell script to apply c4b patches to a current source tree
#
# usage:
#
# ./do-patches.sh [source tree base directory]
#

SRCBASE=/usr/src
PATCHDIR=`pwd`
C4BBASE=`pwd`/../..
BCKSFX=".org.c4b"



# Function to perform a patch with some required settings
# Note: The current directory must be set to the source tree base.
exec-patch()
{
   echo "patch -b ${BCKSFX} -N < $1"
   patch -b ${BCKSFX} -N < "$1"
}



# Evaluate command line parameters
while [ -n "$1" ]; do
   case "$1" in
      *)        SRCBASE="$1"; shift ;;
   esac
done



# Determine the full operating system name
t=`grep ^TYPE= "${SRCBASE}/sys/conf/newvers.sh"`
r=`grep ^REVISION= "${SRCBASE}/sys/conf/newvers.sh"`
b=`grep ^BRANCH= "${SRCBASE}/sys/conf/newvers.sh"`
if [ -z "$t" -o -z "$r" -o -z "$b" ]; then
   echo "ERROR: Failed to extract TYPE, REVISION and BRANCH from \"${SRCBASE}/sys/conf/newvers.h\""
   exit 1
fi
eval $t
eval $r
eval $b
# If the BRANCH is "Current", it must be newer than "Release". So in this
# case we just use "=" as the last separator instead of "-" for RELEASE.
case "$BRANCH" in
   [Cc][Uu][Rr][Rr][Ee][Nn][Tt])
      OSNAME="${TYPE}-${REVISION}=${BRANCH}" ;;
   
   *)
      OSNAME="${TYPE}-${REVISION}-${BRANCH}" ;;
esac
   


echo "Patching source tree at \"${SRCBASE}\" for \"${OSNAME}\""
sleep 3
cd ${SRCBASE}



# Copy all c4b related files and directories to their place
# Note: The current directory must be the current source tree base.

# lib/libcapi20
echo "Copy libcapi20 sources..."
[ -d lib/libcapi20 ] || mkdir -p lib/libcapi20
cp ${C4BBASE}/libcapi20/*.c ${C4BBASE}/libcapi20/*.[0-9] lib/libcapi20
cp ${C4BBASE}/libcapi20/Makefile lib/libcapi20/Makefile

# CAPI include files
echo "Copy CAPI include files..."
[ -d sys/c4b/include ] || mkdir -p sys/c4b/include
cp ${C4BBASE}/include/capi*.h sys/c4b/include

# sys/c4b/kcapimgr
echo "Copy kcapimgr sources..."
[ -d sys/c4b/kcapimgr ] || mkdir -p sys/c4b/kcapimgr
cp ${C4BBASE}/kcapimgr/*.h ${C4BBASE}/kcapimgr/*.c sys/c4b/kcapimgr

# sys/c4b/capidev
echo "Copy capidev sources..."
[ -d sys/c4b/capidev ] || mkdir -p sys/c4b/capidev
cp ${C4BBASE}/capidev/*.c sys/c4b/capidev

# sys/c4b/driver/avmaic
echo "Copy avmaic sources..."
[ -d sys/c4b/driver/avmaic ] || mkdir -p sys/c4b/driver/avmaic
cp ${C4BBASE}/driver/avmaic/*.h ${C4BBASE}/driver/avmaic/*.c sys/c4b/driver/avmaic

# sys/c4b/driver/daic
echo "Copy daic sources..."
[ -d sys/c4b/driver/daic ] || mkdir -p sys/c4b/driver/daic
cp ${C4BBASE}/driver/daic/*.h ${C4BBASE}/driver/daic/*.c sys/c4b/driver/daic

# sys/c4b/driver/ix1a
echo "Copy ix1a sources..."
[ -d sys/c4b/driver/ix1a ] || mkdir -p sys/c4b/driver/ix1a
cp ${C4BBASE}/driver/ix1a/*.h ${C4BBASE}/driver/ix1a/*.c sys/c4b/driver/ix1a

# sys/i4b/i4bcapimgr
echo "Copy i4bcapimgr sources..."
[ -d sys/i4b/i4bcapimgr ] || mkdir -p sys/i4b/i4bcapimgr
cp ${C4BBASE}/i4b/i4bcapimgr/*.h ${C4BBASE}/i4b/i4bcapimgr/*.c sys/i4b/i4bcapimgr

# sys/modules/kcapimgr/Makefile
echo "Copy kcapimgr Makefile..."
[ -d sys/modules/kcapimgr ] || mkdir -p sys/modules/kcapimgr
cp ${C4BBASE}/modules/kcapimgr/Makefile.kernel sys/modules/kcapimgr/Makefile

# sys/modules/capidev/Makefile
echo "Copy capidev Makefile..."
[ -d sys/modules/capidev ] || mkdir -p sys/modules/capidev
cp ${C4BBASE}/modules/capidev/Makefile.kernel sys/modules/capidev/Makefile

# sys/modules/avmaic/Makefile
echo "Copy avmaic Makefile..."
[ -d sys/modules/avmaic ] || mkdir -p sys/modules/avmaic
cp ${C4BBASE}/modules/driver/avmaic/Makefile.kernel sys/modules/avmaic/Makefile

# sys/modules/daic/Makefile
echo "Copy daic Makefile..."
[ -d sys/modules/daic ] || mkdir -p sys/modules/daic
cp ${C4BBASE}/modules/driver/daic/Makefile.kernel sys/modules/daic/Makefile

# sys/modules/ix1a/Makefile
echo "Copy ix1a Makefile..."
[ -d sys/modules/ix1a ] || mkdir -p sys/modules/ix1a
cp ${C4BBASE}/modules/driver/ix1a/Makefile.kernel sys/modules/ix1a/Makefile

# sys/modules/i4bcapimgr/Makefile
echo "Copy i4bcapimgr Makefile..."
[ -d sys/modules/i4bcapimgr ] || mkdir -p sys/modules/i4bcapimgr
cp ${C4BBASE}/modules/i4bcapimgr/Makefile.kernel sys/modules/i4bcapimgr/Makefile

# usr.sbin/c4b
echo "Copy c4b tools sources..."
[ -d usr.sbin/c4b ] || mkdir -p usr.sbin/c4b
cp ${C4BBASE}/Makefile.tools usr.sbin/c4b/Makefile
cp ${C4BBASE}/Makefile.tools.inc usr.sbin/c4b/Makefile.inc
cp ${C4BBASE}/TODO usr.sbin/c4b

# usr.sbin/c4b/common
[ -d usr.sbin/c4b/common ] || mkdir -p usr.sbin/c4b/common
cp ${C4BBASE}/common/*.h ${C4BBASE}/common/*.cc usr.sbin/c4b/common

# usr.sbin/c4b/avmaicctl
[ -d usr.sbin/c4b/avmaicctl ] || mkdir -p usr.sbin/c4b/avmaicctl
cp ${C4BBASE}/avmaicctl/Makefile ${C4BBASE}/avmaicctl/*.h ${C4BBASE}/avmaicctl/*.cc ${C4BBASE}/avmaicctl/*.[0-9] usr.sbin/c4b/avmaicctl

# usr.sbin/c4b/capitest
[ -d usr.sbin/c4b/capitest ] || mkdir -p usr.sbin/c4b/capitest
cp ${C4BBASE}/capitest/Makefile ${C4BBASE}/capitest/*.h ${C4BBASE}/capitest/*.cc ${C4BBASE}/capitest/*.[0-9] usr.sbin/c4b/capitest

# usr.sbin/c4b/capitrace
[ -d usr.sbin/c4b/capitrace ] || mkdir -p usr.sbin/c4b/capitrace
cp ${C4BBASE}/capitrace/Makefile ${C4BBASE}/capitrace/*.h ${C4BBASE}/capitrace/*.cc ${C4BBASE}/capitrace/*.[0-9] usr.sbin/c4b/capitrace

# usr.sbin/c4b/daicctl
[ -d usr.sbin/c4b/daicctl ] || mkdir -p usr.sbin/c4b/daicctl
cp ${C4BBASE}/daicctl/Makefile ${C4BBASE}/daicctl/*.h ${C4BBASE}/daicctl/*.cc ${C4BBASE}/daicctl/*.[0-9] usr.sbin/c4b/daicctl

# usr.sbin/c4b/ix1actl
[ -d usr.sbin/c4b/ix1actl ] || mkdir -p usr.sbin/c4b/ix1actl
cp ${C4BBASE}/ix1actl/Makefile ${C4BBASE}/ix1actl/*.h ${C4BBASE}/ix1actl/*.cc ${C4BBASE}/ix1actl/*.[0-9] usr.sbin/c4b/ix1actl

# usr.sbin/c4b/man
[ -d usr.sbin/c4b/man ] || mkdir -p usr.sbin/c4b/man
cp ${C4BBASE}/man/Makefile ${C4BBASE}/man/*.[0-9] usr.sbin/c4b/man

# share/capi
echo "Copy basic files for share/capi..."
[ -d share/capi ] || mkdir -p share/capi
cp ${C4BBASE}/firmware/Makefile ${C4BBASE}/firmware/Makefile.inc share/capi

# share/capi/avmaic
echo "Copy avmaic firmware files..."
[ -d share/capi/avmaic ] || mkdir -p share/capi/avmaic
cp ${C4BBASE}/firmware/avmaic/Makefile share/capi/avmaic
cd ${C4BBASE}/firmware/avmaic
for i in *.t4 *.bin ; do
   uuencode $i $i > ${SRCBASE}/share/capi/avmaic/$i.uu
done
cd ${SRCBASE}
cp -f ${C4BBASE}/firmware/avmaic/README ${C4BBASE}/firmware/avmaic/Makefile share/capi/avmaic

# share/capi/daic
echo "Copy daic firmware files..."
[ -d share/capi/daic ] || mkdir -p share/capi/daic
cp ${C4BBASE}/firmware/daic/Makefile share/capi/daic
cd ${C4BBASE}/firmware/daic
for i in *.bin *.p *.sq *.sx *.sy ; do
   uuencode $i $i > ${SRCBASE}/share/capi/daic/$i.uu
done
cd ${SRCBASE}
cp -f ${C4BBASE}/firmware/daic/README ${C4BBASE}/firmware/daic/Makefile share/capi/daic

# share/capi/ix1a
echo "Copy ix1a firmware files..."
[ -d share/capi/ix1a ] || mkdir -p share/capi/ix1a
cp ${C4BBASE}/firmware/ix1a/Makefile share/capi/ix1a
cd ${C4BBASE}/firmware/ix1a
for i in *.scr *.bin ; do
   uuencode $i $i > ${SRCBASE}/share/capi/ix1a/$i.uu
done
cd ${SRCBASE}
cp -f ${C4BBASE}/firmware/ix1a/README ${C4BBASE}/firmware/ix1a/Makefile share/capi/ix1a

# 5.0-RELEASE and before: etc/rc.capi
if [ ${OSNAME} \< "FreeBSD-5.1-RELEASE" ]; then
   echo "Copy 5.0 startup files..."
   cp ${C4BBASE}/rc.capi etc
fi

# 5.1-RELEASE and up: etc/rc.d/*
if [ ! ${OSNAME} \< "FreeBSD-5.1-RELEASE" ]; then
   echo "Copy 5.1 and up startup files..."
   cp ${C4BBASE}/rc.d/[a-z]* etc/rc.d
fi



# Execute all patches in the current patch directory
for i in "${PATCHDIR}"/patch-* ; do
   echo "Performing patch \"$i\"..."
   exec-patch "$i"
done



echo "Source tree patch complete."

